/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 10-feb-2005
 *
 */
package be.ugent.ftw.intec.sel.aspicere;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * @author bram
 *
 * 10-feb-2005
 */
public class XPathUtilities {
    static Map cache=new HashMap();//HACK (context -> query -> result)
	
    public static List selectNodes(Object root, String query) {
    		/*CACHE*/
    		Map queryToResult=(Map)cache.get(root);
    		if(queryToResult!=null){
    			Object res=queryToResult.get(query);
    			if((res!=null)&&(res instanceof List)) return (List)res;
    		}
    		/*CACHE*/
        try{
            BaseXPath xpath = new DOMXPath(query);
            List res=xpath.selectNodes(root);
    			/*CACHE*/
            if(queryToResult==null) queryToResult=new HashMap();
            	queryToResult.put(query,res);
            	cache.put(root,queryToResult);
            	/*CACHE*/
            return res;
        }catch(JaxenException ex){
            ex.printStackTrace();
            return null;
        }
    }

    public static Object selectSingleNode(Node node, String query) {
		/*CACHE*/
		Map queryToResult=(Map)cache.get(node);
		if(queryToResult!=null){
			Object res=queryToResult.get(query);
			if(res!=null) return res;
		}
		/*CACHE*/
        try{
            BaseXPath xpath = new DOMXPath(query);
            Object res=xpath.selectSingleNode(node);
			/*CACHE*/
            if(queryToResult==null) queryToResult=new HashMap();
            	queryToResult.put(query,res);
            	cache.put(node,queryToResult);
            	/*CACHE*/
            return res;
        }catch(JaxenException ex){
            ex.printStackTrace();
            return null;
        }
    }

    public static List evaluate(Object root, String query) {
		/*CACHE*/
		Map queryToResult=(Map)cache.get(root);
		if(queryToResult!=null){
			Object res=queryToResult.get(query);
			if((res!=null)&&(res instanceof List)) return (List)res;
		}
		/*CACHE*/
        try{    
            BaseXPath xpath = new DOMXPath(query);
            Object obj=xpath.evaluate(root);
            if(obj instanceof String || obj instanceof Number || obj instanceof Boolean ){
                List res=new ArrayList();
                res.add(obj);
    				/*CACHE*/
                if(queryToResult==null) queryToResult=new HashMap();
                	queryToResult.put(query,res);
                	cache.put(root,queryToResult);
                	/*CACHE*/
                return res;
            }
			/*CACHE*/
            if(queryToResult==null) queryToResult=new HashMap();
            	queryToResult.put(query,(List)obj);
            	cache.put(root,queryToResult);
            	/*CACHE*/
            return (List)obj;
        }catch(JaxenException ex){
            ex.printStackTrace();
            return null;
        }
    }

    public static String stringValueOf(Node node, String query) {
		/*CACHE*/
		Map queryToResult=(Map)cache.get(node);
		if(queryToResult!=null){
			Object res=queryToResult.get(query);
			if((res!=null)&&(res instanceof String)) return (String)res;
		}
		/*CACHE*/
        try{
            BaseXPath xpath = new DOMXPath(query);
            String res=xpath.stringValueOf(node);
			/*CACHE*/
            if(queryToResult==null) queryToResult=new HashMap();
            	queryToResult.put(query,res);
            	cache.put(node,queryToResult);
            	/*CACHE*/
            return res;
        }catch(JaxenException ex){
            ex.printStackTrace();
            return null;
        }
    }
    /**
     * Walk through DOM-tree to stringify it (only print text).
     * 
     * @param node
     */
    public static String stringify(Node node){
    		String res="";
        int type = node.getNodeType();

        switch (type) {
        case Node.COMMENT_NODE: {
            //res+=node.getNodeValue();
        		res+=" ";
            break;
        }
        case Node.ENTITY_REFERENCE_NODE: {

            res+="&" + node.getNodeName() + ";";
            break;

        }//end of entity
        /*case Node.CDATA_SECTION_NODE: {
        		res+="<![CDATA[" + node.getNodeValue() + "]]>";
            break;

        }*/
        case Node.TEXT_NODE: {
        		res+=node.getNodeValue();
            break;
        }
        /*case Node.PROCESSING_INSTRUCTION_NODE: {
            System.out.print("<?" + node.getNodeName());
            String data = node.getNodeValue();
            if (data != null && data.length() > 0) {
                System.out.print(' ');
                System.out.print(data);
            }
            System.out.println("?>");
            break;

        }*/
        }//end of switch

        //recurse
        for (Node child = node.getFirstChild(); child != null; child = child
                .getNextSibling()) {
            res+=stringify(child);
        }

        //without this the ending tags will miss
        /*if (type == Node.ELEMENT_NODE) {
            System.out.print("</" + node.getNodeName() + ">");
        }*/
        return res.trim()+" ";
    }
    
    /**
     * Walk through DOM-tree to print it on stdout. Copy-paste from
     * http://members.fortunecity.com/seagull98/XmlTutorial.html.
     * 
     * @param node
     */
    public static void walk(Node node) {
    	walk(node,System.out);
    }
    
    public static void walk(Node node,PrintStream str) {
        int type = node.getNodeType();

        switch (type) {
        case Node.DOCUMENT_NODE: {
            str.println("<?xml version=\"1.0\" encoding=\"" + "UTF-8"
                    + "\"?>");
            break;
        }//end of document
        case Node.COMMENT_NODE: {
            str.print("<!--" + node.getNodeValue() + "-->");
            break;
        }
        case Node.ELEMENT_NODE: {
            str.print('<' + node.getNodeName());
            NamedNodeMap nnm = node.getAttributes();
            if (nnm != null) {
                int len = nnm.getLength();
                Attr attr;
                for (int i = 0; i < len; i++) {
                    attr = (Attr) nnm.item(i);
                    str.print(' ' + attr.getNodeName() + "=\""
                            + attr.getNodeValue() + '"');
                }
            }
            str.print('>');

            break;

        }//end of element
        case Node.ENTITY_REFERENCE_NODE: {

            str.print('&' + node.getNodeName() + ';');
            break;

        }//end of entity
        case Node.CDATA_SECTION_NODE: {
            str.print("<![CDATA[" + node.getNodeValue() + "]]>");
            break;

        }
        case Node.TEXT_NODE: {
            str.print(node.getNodeValue());
            break;
        }
        case Node.PROCESSING_INSTRUCTION_NODE: {
            str.print("<?" + node.getNodeName());
            String data = node.getNodeValue();
            if (data != null && data.length() > 0) {
                str.print(' ');
                str.print(data);
            }
            str.println("?>");
            break;

        }
        }//end of switch

        //recurse
        for (Node child = node.getFirstChild(); child != null; child = child
                .getNextSibling()) {
            walk(child,str);
        }

        //without this the ending tags will miss
        if (type == Node.ELEMENT_NODE) {
            str.print("</" + node.getNodeName() + ">");
        }
    }
}
