/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologStringLibrary').
:- load_library('be.ugent.ftw.intec.sel.aspicere.TUPrologGeneralPurposeLibrary').

/*Does List have a known, fixed length and what is it?*/
concrete_list(List,Length):-
    nonvar(List),
    generalpurpose_finite_list(List),
    length(List,Length)
    .

unifyLists([],[]).
unifyLists([A|RestOfA],[A|RestOfB]):-
	unifyLists(RestOfA,RestOfB)
	.

/*Standard length/2 unifies variables in list with _ <--> last version of 2Prolog?*/
ourlength([],0).
ourlength([L|List],N):-
	ourlength(List,N1),
	N is N1+1
	.
	
zip([],[],[]).
zip([One|List1],[Two|List2],[[One,Two]|List]):-
	zip(List1,List2,List)
	.

mth(1,[A|_],A) :-
	!.
mth(N,[_|Rest],Res) :-
	M is N - 1,
	mth(M,Rest,Res).


/*Text is argument of a function*/
stringify(Text,StrText):-
	sys_instanceof(Text,List),
	member('org.w3c.dom.Node',List),
	!,
	xpath_query('count(preceding-sibling::NAssignExpr)',Text,Results),
	arg(1,Results,Index),
	Ind is Index div 1,%float_integer_part does NOT work apparently
	text_term(IndText,Ind),
	text_concat('(*((char**)(jp->args[',IndText,Tmp),
	text_concat(Tmp,'])))',StrText)
	.

/*Text is NO argument of function*/
stringify(Text,StrText):-                       
	text_concat('"',Text,Tmp),
	text_concat(Tmp,'"',StrText)
	.

/*concat(A,[],[A]).
concat(A,B,[A|B]).*/
