/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

:- load_library('be.ugent.ftw.intec.sel.aspicere.TUPrologDOMXPathLibrary').
:- load_library('be.ugent.ftw.intec.sel.aspicere.TUPrologHyperPrimitiveLibrary').
:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologDOMXMLLibrary').
:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologStringLibrary').

we_require('ASPICERE','layers/general-purpose').

/*No bindings*/
createJPs(Name,XPathQuery,JpList):-
	print('enter CREATE-LIGHT'),nl,
	xmldoc(Document),
	%print('QUERY: '),write(XPathQuery),nl,
	xpath_query(XPathQuery,Document,NodeList),
	print('All/Selected:'),nl,write(NodeList),nl,
	%checkBindings(NodeList,BindingList,GoodNodeListWithBindings),
	%print('BindingList:'),nl,write(BindingList),nl,
	%zip(GoodNodeList,BoundList,GoodNodeListWithBindings),
	%print('Selected:'),nl,write(GoodNodeList),nl,
	xpath_create_joinpoints(Name,NodeList,JpList),
	%zip(JpList,BoundList,JpListWithBindings),
	print('exit CREATE-LIGHT'),nl
	.

/*BindingList is een lijst met XPath-queries waaraan gezochte joinpoints moeten voldoen. MISSCHIEN bruikbaar als sequentie van nodes i.p.v. één root node, omdat selectNodes ook verzameling van Nodes aanvaardt!!!!*/
createJPs(Name,XPathQuery,JpListWithBindings,BindingList):-
	print('enter CREATE'),nl,
	xmldoc(Document),
	%print('QUERY: '),write(XPathQuery),nl,
	xpath_query(XPathQuery,Document,NodeList),
	print('All:'),nl,write(NodeList),nl,
	checkBindings(NodeList,BindingList,GoodNodeListWithBindings),
	%print('BindingList:'),nl,write(BindingList),nl,
	zip(GoodNodeList,BoundList,GoodNodeListWithBindings),
	print('Selected:'),nl,write(GoodNodeList),nl,
	xpath_create_joinpoints(Name,GoodNodeList,JpList),
	zip(JpList,BoundList,JpListWithBindings),
	print('exit CREATE'),nl
	.

/*on Jp*/
checkBindings(Jp,BindingList):-
	hyperprimitive_get_node_for_JP(Jp,Node),
	performBindings(Node,BindingList)
	.

/*on list of Nodes*/
checkBindings(NodeList,BindingList,GoodNodeListWithBindings):-
	findall(
		[GoodNode,BindingList],
		performBindingList(NodeList,BindingList,GoodNode),
		GoodNodeListWithBindings
	)
	.

performBindingList(NodeList,[],GoodNode):-
	!,
	member(GoodNode,NodeList)		%,
	%print('# second empty'),nl
	.
/*performBindingList([],_):-
	!%,
	%print('# first empty'),nl
	.*/
performBindingList([Node|NodeList],BindingList,GoodNode):-
	(
	  performBindings(Node,BindingList),
	  GoodNode is Node
	;
	  performBindingList(NodeList,BindingList,GoodNode)
	)
	.

/*Values is lijst!*/
performBindings(Node,[]).
performBindings(Node,[[Query,Values]|BindingList]):-
	%print('# binding node '),write(Node),nl,
	%print('QUERY: '),write(Query),nl,
	%print('VALUES: '),write(Values),nl,	
	xpath_query(Query,Node,List),
	%print('LIST: '),write(List),nl,
	unifyLists(List,Values),
	%print('VALUES: '),write(Values),nl,	
	%print('# ... OK'),nl,
	performBindings(Node,BindingList)
	.
