/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologStringLibrary').
:- load_library('be.ugent.ftw.intec.sel.aspicere.TUPrologPrimitiveLibrary').



we_require('ASPICERE','layers/hyperprimitive').
we_require('ASPICERE','layers/general-purpose').

call(JP,NamePattern):-
	var(NamePattern),
	!,
	print('enter CALLVAR'),nl,

	createJPs('call','//NFunctionCall[preceding-sibling::NIdentifier and not(preceding-sibling::string[1][string(.)="." or string(.)="-&gt;"])]',JPListWithBindings,[['translate(normalize-space(string(./preceding-sibling::NIdentifier/string))," ","")',N]]),

	member(JPWithBinding,JPListWithBindings),
	mth(1,JPWithBinding,JP),
	mth(2,JPWithBinding,Binding),
	
	mth(1,Binding,NamePatternTmpList),
	mth(2,NamePatternTmpList,NamePatternList),
	mth(1,NamePatternList,NamePattern),

	print('Call to '),write(NamePattern),print('.'),nl,
	%print('Binding:'),nl,write(Bindings),nl,
	%print('QUERY: '),write(Query),nl,
	%print('HIT: '),write(JP),nl,
	print('exit CALLVAR'),nl
	.

call(JP,NamePattern):-
	nonvar(NamePattern),
	!,
	print('enter CALLNONVAR'),nl,

	text_concat('//NFunctionCall[matches(./preceding-sibling::NIdentifier/string,"',NamePattern,Tmp1),
	text_concat(Tmp1,'") and not(preceding-sibling::string[1][string(.)="." or string(.)="-&gt;"])]',Query),
	createJPs('call',Query,JPList),

	member(JP,JPList),
	%mth(1,JPWithBinding,JP),

	print('Call to '),write(NamePattern),print('.'),nl,
	%print('Binding:'),nl,write(Bindings),nl,
	%print('QUERY: '),write(Query),nl,
	%print('HIT: '),write(JP),nl,
	print('exit CALLNONVAR'),nl
	.

args(JP,ParList):-
	nonvar(JP),
	%nonvar(ParList),
	concrete_list(ParList,NPar),
	!,
	%print('enter ARGSNONVAR'),nl,

	%length(ParList,NPar),
	checkBindings(JP,[['round(count(NArgExpr))',[NPar]],['NArgExpr',ParList]])
	%print('exit ARGSNONVAR'),nl
	.


args(JP,ParList):-
	nonvar(JP),
	%var(ParList),%also allow [A|_]
	!,
	%print('enter ARGSVAR'),nl,

	checkBindings(JP,[['NArgExpr',ParList]])
	%print('exit ARGSVAR'),nl
	.


/* -NamePattern,@ParList */
call(JP,NamePattern,ParList):-
	var(NamePattern),
	concrete_list(ParList,NPar),
	!,
	print('enter CALL1'),nl,

	%length(ParList,NPar),
	
	createJPs('call','//NFunctionCall[./preceding-sibling::NIdentifier]',JPListWithBindings,[['round(count(NArgExpr))',[NPar]],['NArgExpr',ParList],['translate(normalize-space(string(./preceding-sibling::NIdentifier/string))," ","")',N]]),

	member(JPWithBinding,JPListWithBindings),
	mth(1,JPWithBinding,JP),
	mth(2,JPWithBinding,Binding),
	mth(2,Binding,BindingTmpList),
	mth(2,BindingTmpList,Bindings),%all argument bindings
	unifyLists(ParList,Bindings),%bad code: duplication, because findall ruins the whole experience
	
	mth(3,Binding,NamePatternTmpList),
	mth(2,NamePatternTmpList,NamePatternList),
	mth(1,NamePatternList,NamePattern),
	
	print('Binding:'),nl,write(Bindings),nl,
	%print('QUERY: '),write(Query),nl,
	%print('HIT: '),write(JP),nl,
	print('exit CALL'),nl
	.

/* -NamePattern,-ParList */
call(JP,NamePattern,ParList):-
	var(NamePattern),
	%var(ParList),%also allow [A|_]
	!,
	print('enter CALL2'),nl,

	createJPs('call','//NFunctionCall[./preceding-sibling::NIdentifier]',JPListWithBindings,[['NArgExpr',ParList],['translate(normalize-space(string(./preceding-sibling::NIdentifier/string))," ","")',N]]),
	member(JPWithBinding,JPListWithBindings),
	mth(1,JPWithBinding,JP),
	mth(2,JPWithBinding,Binding),
	mth(1,Binding,BindingTmpList),
	mth(2,BindingTmpList,Bindings),%all argument bindings
	unifyLists(ParList,Bindings),%bad code: duplication, because findall ruins the whole experience

	mth(2,Binding,NamePatternTmpList),
	mth(2,NamePatternTmpList,NamePatternList),
	mth(1,NamePatternList,NamePattern),
	
	print('Binding:'),nl,write(Bindings),nl,
	%print('QUERY: '),write(Query),nl,
	%print('HIT: '),write(JP),nl,
	print('exit CALL'),nl
	.

/* @NamePattern,@ParList */
call(JP,NamePattern,ParList):-
	concrete_list(ParList,NPar),
	!,
	print('enter CALL3'),nl,
	%length(ParList,NPar),
    %print('ParList:'),nl,write(ParList),nl,
    %print('has :'),write(NPar),print(' elements!'),nl,
	
	text_concat('//NFunctionCall[matches(./preceding-sibling::NIdentifier/string,''',NamePattern,Tmp1),
	text_concat(Tmp1,''')]',Query),
	createJPs('call',Query,JPListWithBindings,[['round(count(NArgExpr))',[NPar]],['NArgExpr',ParList]]),

	member(JPWithBinding,JPListWithBindings),
	mth(1,JPWithBinding,JP),
	mth(2,JPWithBinding,Binding),
	mth(2,Binding,BindingTmpList),
	mth(2,BindingTmpList,Bindings),%all argument bindings
	unifyLists(ParList,Bindings),%bad code: duplication, because findall ruins the whole experience
	
	print('Binding:'),nl,write(Bindings),nl,
	%print('QUERY: '),write(Query),nl,
	%print('HIT: '),write(JP),nl,
	print('exit CALL'),nl
	.

/* @NamePattern,-ParList */	
call(JP,NamePattern,ParList):-
	print('enter CALL4'),nl,
	
	text_concat('//NFunctionCall[matches(string(preceding-sibling::NIdentifier/string),''',NamePattern,Tmp1),
	text_concat(Tmp1,''')]',Query),
    %print('PREPREPREPREPREPREPREPREPREPRE'), nl,
	createJPs('call',Query,JPListWithBindings,[['NArgExpr',ParList]]),
    %print('POSTPOSTPOSTPOSTPOSTPOSTPOSTPOST'), nl,

	member(JPWithBinding,JPListWithBindings),
	mth(1,JPWithBinding,JP),
	mth(2,JPWithBinding,Binding),
	mth(1,Binding,BindingTmpList),
	mth(2,BindingTmpList,Bindings),%all argument bindings
	unifyLists(ParList,Bindings),%bad code: duplication, because findall ruins the whole experience
	
	print('Binding:'),nl,write(Bindings),nl,
	%print('QUERY: '),write(Query),nl,
	%print('HIT: '),write(JP),nl,
	print('exit CALL'),nl
	.
	
type(JoinPoint,ReturnType):-
	primitive_returntype(JoinPoint,ReturnType)
	.
	
name(MethodNode, Name):-
	primitive_method_node_name(MethodNode,Name)
    .

/*Method is XML-structuur van functiedefinitie*/
enclosingMethod(Jp,Method):-
	primitive_enclosing_method_node(Jp,Method)	
	.
	
execution(JP,NamePattern,QualifierList,ParList,ReturnType):-
	print('CHECK execution'),nl,
	str_matches(Name,'f.*re'),
	print('BINGO execution'),
	nl
	.
