/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
#include "sql.h"

int sql_code=0;

static double wages[]={1000.0,2010.3,1234.0,5321.5,2221.1,1000.0,2010.3,1234.0,5321.5,2221.1,1000.0,2010.3,1234.0,5321.5,2221.1,1000.0,2010.3,1234.0,5321.5,2221.1};
static char* names[]={"Tom Mens","Magiel Bruntink","Bart Dubois","Yves Vandewoude","Ghislain Hoffman","Thomas Cleenewerck","Theo D'hondt","Kris De Schutter","Niels Van Eetvelde","Kim Mens","Peter Ebraert","Roel Wuyts","Bram Adams","Ragnhild Van Der Straeten","Koenraad Vandenborre","Herman Tromp","Tijs Van Buggenhout","David Matthys","Anthony Cleve","Jean Henrard"};
static char* accounts[]={"437123456789","979123456789","063123456789","437456789123","979456789123","063456789123","437123123456","979123123456","063123123456","437123789456","979123789456","063123789456","437456123456","979456123456","063456123456","437123456456","979123456456","063123456456","979456456456","063456456456"};

static int count(char* s,char* part);

sqcursor* _iqcprep(char* query,...){
  int loop;
  va_list ap;
  sqcursor* res=0;

  int num_args=count(query,"%d");

  srand(79);
  va_start(ap,query);
  
  if(num_args==1){
    int id=va_arg(ap,int);
    res=(sqcursor*)malloc(num_args*sizeof(sqcursor));
    res->next_index=id;
    res->upper_index=id;
    res->query=query;
  }else{
    int lower_id=va_arg(ap,int);
    int upper_id=va_arg(ap,int);
    res=(sqcursor*)malloc(num_args*sizeof(sqcursor));
    res->next_index=lower_id;
    res->upper_index=upper_id;
    res->query=query;
  }

  va_end(ap);
  
  sql_code=0;

  return res;
}

int _iqcftch(sqcursor *cursor, sqlda *odesc){
  int next=cursor->next_index;
  int upper=cursor->upper_index;
  static int counter=0;
  int destiny=(counter++) % 20;

  /*pseudo-randomly returning error code*/
  if(next==0) return 0;
  
  if(destiny==4 || destiny == 6){ /*cursor unmodified*/
    sql_code=-666;

  }else if(destiny==7){ /*cursor unmodified*/
    sql_code=-357;

  }else if(destiny==10){ /*cursor unmodified*/
    sql_code=-910;

  }else{ /*only do something real here*/
    if(strstr(cursor->query,"accounting")){ /*"select ID,wage,accountnr from accounting where %d <= ID <= %d"*/
      odesc->id=next;
      odesc->wage=wages[next-1];
      odesc->accountnr=accounts[next-1];
    }else{ /*"select ID,name from population where ID = %d"*/
      odesc->id=next;
      odesc->name=names[next-1];
    }

     if(next==upper) cursor->next_index=0; 
     else (cursor->next_index)++; 

    sql_code=0;
  } 

  return next;
}

void _iqcfin(sqcursor *cursor){
  free(cursor);
}

/**
   @brief Find the number of times part occurs in s.
   @param s given string
   @param part substring to look for
   @returns number of times part occurs in s
 */
static int count(char* s,char* part){
  char* p=s;
  int nrFound=0;
  int len=strlen(part);

  while(p=strstr(p, part)){
    nrFound++;
    p+=len;
  }

  return nrFound;
}

