/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Stijn Van Wonterghem <wontie@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


/*****************************************************************************
 *  main.c, part of AspectC v0.0.7
 *  Testing File for Advice & Poincut implementations 
 *   
 *  Kris De Schutter @ UGent
 *  Stijn Van Wonterghem @ UGent
 *  13/07/2004 
 *****************************************************************************/

#include <stdio.h>

static double resAA=2.3;

int or ( int x, int y ) {
  if (x || y)
    return 1;
  else
    return 0;
}

int and ( int x, int y ) {
  printf("AND:\t%d\n",or(1,1));
  if (x && y)
    return 1;
  else
    return 0;
}

int not ( int x ) {
  if (!x)
    return 1;
  else
    return 0;
}

int xor_A ( int x, int y ) {
  if ((x || y) && !(x && y))
    return 1;
  else
    return 0;
}

int xor_B ( int x, int y ) {
  if (and (or (x, y), not (and (x, y))))
    return 1;
  else
    return 0;
}


int main () {
  int x = 1;
  int y = 1;

  int resA=xor_A (x, y);
  int resB=xor_B (x, y);

  if ( resA == resB ) {
    printf ("Out: Yeah! That's how it should be!.\n");
    {
      resAA=2.4;
      printf("testA:\t%lf\n",resAA);
    }
    return 0;
  } else {
    printf ("Out: Boo! Something's wrong here!.\n");
    printf("xor_A:\t%d\n",resA);
    printf("xor_B:\t%d\n",resB);
    return 1;
  }
}
