/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologStringLibrary').
:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologSystemLibrary').
:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologDOM4JXMLLibrary').

%there are two series of tests: by default the xml-tests are enabled (act-predicate)
%to test the strings, rename act to act_xml and act_string to act

age(john, 21).
age(mark, 33).
age(lisa, 7).

act(Names, Ages) :-
	print('Welcome to dummy2!!!'),
	nl,
	print('#test xml_create_DOM:'),
	nl,
	xml_from_file('agents/lillambi/tests/xml-predicates/slide.xml',Doc),
	nl,
	print('#test xml_print_DOM:'),
	nl,
	xml_print_DOM(Doc),
	nl,
	%print('#test xml_iterate:'),
	nl,
	%xml_iterate(Doc),
	print('#test xml_first_child:'),
	nl,
	print('   ->ground-var'),
	nl,
	xml_first_child(Doc,Child11),%ground-var
	xml_print_DOM(Child11),
	%xml_first_child(Doc,Root),%ground-var
	%xml_print_DOM(Root),
	nl,
	print('#test xml_next:'),
	nl,
	xml_first_child(Child11,Child1),
	xml_next(Child1,Root),
	xml_print_DOM(Root),
	nl,
	print('   ->var-ground'),
	nl,
	xml_first_child(Root,Child2_text),
	xml_next(Child2_text,Child2_comment),
	xml_next(Child2_comment,Child2_text2),
	xml_next(Child2_text2,Child2),
	xml_print_DOM(Child2),
	nl,
	xml_first_child(Root2,Child2_text),%var-ground
	print('#2 verschillende IDs: '),
	write(Root),
	print(' <-> '),
	write(Root2),
	nl,
	xml_print_DOM(Root2),
	nl,
	print('   ->ground-ground'),
	nl,	
	xml_first_child(Root2,Child2_text),%ground-ground
	nl,
 	print('#test xml_value op Child2_comment:'),
	nl,
	xml_value(Child2_comment,Value),%ground-var
	write(Value),
	xml_value(Child2_comment,Value),%ground-ground
 	nl,
	print('#test xml_first op Child2_comment:'),
	nl,
	xml_first(Child2_comment,Child2_text_2),%ground-var
	xml_print_DOM(Child2_text_2),
	xml_first(Child2_comment,Child2_text_2),%ground-ground
 	nl,
	print('OK!'),
	nl,
	print('#test xml_last op Child1:'),
	nl,
	xml_last(Child1,Root3),%ground-var
	xml_print_DOM(Root3),
	xml_last(Child1,Root3),%ground-ground
 	nl,
	print('OK!'),
	nl,	
	print('#test xml_last_child op Root en dan sibling ervoor met xml_next:'),
	nl,
	xml_last_child(Root,Last),%ground-var
	xml_next(VoorLast,Last),
	xml_print_DOM(VoorLast),
	xml_last_child(Child,Last),%ground-ground
 	nl,
	print('OK!'),
	nl,
	print('#test xml_is_leaf op Root2 en Child2_text_2:'),	
 	nl,
	(
	  xml_is_leaf(Root2),
	  print('BAD match'),
	  nl
	;
	  xml_is_leaf(Child2_text_2),
	  print('GOOD match'),
	  nl
	),
	print('OK!'),
	nl,
	print('#test xml_is_root op Root2 en Doc:'),	
 	nl,
	(
	  xml_is_root(Root2),
	  print('BAD match'),
	  nl
	;
	  xml_is_root(Doc),
	  print('GOOD match'),
	  nl
	),
	print('OK!'),
	nl,
	print('#test xml_make_comment op Doc:'),
	nl,
	xml_make_comment(Doc,'Wat interessant zeg!',Comment),
	xml_print_DOM(Comment),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_make_element op Doc:'),
	nl,
	xml_make_element(Doc,'slide',Element),
	xml_print_DOM(Element),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_make_text op Doc:'),
	nl,
	xml_make_text(Doc,'Wat interessant zeggg!',Text),
	xml_print_DOM(Text),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_all_named op Doc:'),
	nl,
	xml_all_named('slide',Doc,Slides),
	print_DOM_list(Slides),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_name op Doc:'),
	nl,
	xml_name(Doc,Name),%ground-var
	str_out_println(Name),
	xml_name(Doc,Name),%ground-ground
 	nl,
	print('OK!'),
	nl,
	print('#test xml_owner op Root:'),
	nl,
	xml_owner(Root,Owner),%ground-var
	xml_print_DOM(Owner),
	xml_owner(Root,Owner),%ground-ground
 	nl,
	print('OK!'),
	nl,
	print('#test xml_parent op Root:'),
	nl,
	xml_parent(Root,Parent),%ground-var
	xml_print_DOM(Parent),
	xml_parent(Root,Parent),%ground-ground
 	nl,
	print('OK!'),
	nl,
	print('#test xml_prepend op eerste slide:'),
	nl,
	head(Slides,Head),
	xml_prepend(Element,Head),
	xml_print_DOM(Doc),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_clone op Element en xml_append_child op Root:'),
	nl,
	xml_clone(Element,Element2),	
	xml_append_child(Element2,Root),
	xml_print_DOM(Doc),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_children op Root:'),
	nl,
	xml_children(Root,Roots),
	print_DOM_list(Roots),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_swap op clone van Element en Child2_text:'),
	nl,
	xml_clone(Element,Element3),
	xml_swap(Child2_text,Element3),
	xml_print_DOM(Doc),
 	nl,
	print('OK!'),
	nl,
	print('#test xml_type op Child2_comment:'),
	nl,
	xml_type(Child2_comment,Type),%ground-var
	write(Type),
	xml_type(Child2_comment,Type),%ground-ground
 	nl,
	print('OK!'),
	nl,
	print('#test xml_to_file op Doc:'),
	nl,
	xml_to_file('agents/lillambi/tests/xml-predicates/res.xml',Doc),
 	nl,
	print('OK!'),
	nl,	
 	print('#test xml_remove op Root2:'),	
 	nl,
 	xml_remove(Root2),
	xml_print_DOM(Doc),
	nl,
 	lookup(Names, Ages).

act_string(Names, Ages) :-
	print('Welcome to dummy2!!!'),
	nl,
	print('#test str_cat en str_trim:'),
	nl,
	str_cat(['  one','two','three  '],Res),
	str_trim(Res,Res2),
	write('|'),
	write(Res),
	write('|'),
	write(Res2),
	write('|'),
	nl,
	print('#test str_int:'),
	nl,
	str_int('2456',V),
	R is V+1,
	print('is dit 2457? '),
	write(R),
	nl,
	print('#test str_matches:'),
	nl,
	(
	  str_matches('a*bc+','aaaaaaaaaaaaaaaab'),
	  print('bad match!')
	;
	  str_matches('\da*bc+','4aaaaaaaaaaaaaaaabc'),
	  print('GOOD match!')
	),
	nl,
	print('#test str_is_whitespace:'),
	Str='ç\thi\tç\njkjkjljl\q\\qqq\rdqdqd\dsds\"',
	print(Str),
	nl,
	(
	  str_is_whitespace('t'),
	  print('bad match!')
	;
	  str_is_whitespace('    \t     \n        '),
	  print('GOOD match!')
	),
	nl,
	print('#test sys_variable:'),
	nl,
	(
	  sys_variable('HAHA',Sys1),
	  print('bad match!: '),
	  write('£'),
	  write(Sys1),
	  write('£'),	  
	  nl
	;
	  sys_variable('LILLAMBI',Sys2),
	  print('GOOD match!: '),
	  write('£'),	  
	  write(Sys2),
	  write('£'),	  
	  nl
	),
	nl,
	lookup(Names, Ages).
  
act_consult(Names, Ages) :-
	print('Welcome to dummy2!!!'),
	nl,
  print('Testing consult & require_lib in TuProlog'),
  nl,	
  (
   print('consulting...'),
   nl,
   consult('tools.pl'),
   print('consulted'),
   nl,
   print('requiring...'),
   nl,
   require('tools.pl'),
   print('required'),
   nl,
   available('tools.pl'),
   print('tools available!'),
   nl,
   require_lib('YERNA_LINDALE','xml.pl'),
   print('require_lib working!'),
   nl
  ) 
  ;
  (
   print('problem!'),
   nl
  ),
  nl,
 	lookup(Names, Ages).
  
print_DOM_list([H|R]):-
	xml_print_DOM(H),
	nl,
	print_DOM_list(R)
	.
print_DOM_list([]).

lookup([], []).

lookup([N|Names], [A|Ages]) :-
  age(N, A),
  lookup(Names, Ages).

lookup([N|Names], [undef|Ages]) :-
  \+ age(N, _),
  lookup(Names, Ages).

head([A|_],A).  