/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package be.ugent.ftw.intec.sel.lillambi.agents;

import java.util.Properties;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

import be.ugent.ftw.intec.sel.lillambi.Agent;
import be.ugent.ftw.intec.sel.lillambi.AgentNotLoaded;
import be.ugent.ftw.intec.sel.lillambi.Factory;
import be.ugent.ftw.intec.sel.lillambi.Lillambi;

public class JavaFactory implements Factory {

    static {
        Lillambi.addFactory (new JavaFactory ());
    }

    public Agent build (Properties props) throws AgentNotLoaded {
        String className = null;
        Class classForAgent = null;

        String pathToAgent = props.getProperty ("lillambi.agent_path");
        String agentName = props.getProperty ("lillambi.agent_name");

        String location = props.getProperty ("agent.location");

        if (location.equals ("classpath")) {
            /* Easy : class is on the path. */
            className = props.getProperty ("agent.classname");
            try {
                classForAgent = Class.forName (className);

            } catch (ClassNotFoundException e) {
                throw new AgentNotLoaded ("Agent class <" + className
                        + "> not found in environment.");
            }

        } else if (location.equals ("local")) {
            /* Hard : need classloader. */
            String resourceName = pathToAgent
                    + props.getProperty ("agent.resource");
            File resource = new File (resourceName);
            if (!resource.exists ())
                throw new AgentNotLoaded ("Resource <" + resourceName
                        + "> for agent <" + agentName + "> does not exist.");

            URL locator = null;
            try {
                locator = resource.toURI ().toURL ();
            } catch (MalformedURLException e) {
                throw new AgentNotLoaded ("Malformed resource for agent <"
                        + agentName + ">.");
            }

            URLClassLoader loader = new URLClassLoader (new URL[] { locator });
            className = props.getProperty ("agent.classname");
            classForAgent = null;
            try {
                classForAgent = loader.loadClass (className);
            } catch (ClassNotFoundException e) {
                throw new AgentNotLoaded ("Agent class <" + className
                        + "> not found in environment.");
            }
        }

        try {
            Agent agent = (Agent) classForAgent.newInstance ();
            return agent;

        } catch (IllegalAccessException e) {
            throw new AgentNotLoaded ("Access to class <" + className
                    + "> denied.");

        } catch (InstantiationException e) {
            throw new AgentNotLoaded ("Cannot instatiate class <"
                    + className + "> for agent.");
        }
    }
}
