/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 22-nov-2004
 *
 */
package be.ugent.ftw.intec.sel.lillambi.agents;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import alice.tuprolog.Library;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.Tools;

/**
 * @author bram
 * 
 * 22-nov-2004
 */
public class TUPrologDOMXMLLibrary extends Library {

    /**
     *  
     */
    public TUPrologDOMXMLLibrary() {
        super();
    }

    /**
     * Walk through DOM-tree to print it on stdout. Copy-paste from
     * http://members.fortunecity.com/seagull98/XmlTutorial.html.
     * 
     * @param node
     */
    private void walk(Node node) {
        int type = node.getNodeType();

        switch (type) {
        case Node.DOCUMENT_NODE: {
            System.out.println("<?xml version=\"1.0\" encoding=\"" + "UTF-8"
                    + "\"?>");
            break;
        }//end of document
        case Node.COMMENT_NODE: {
            System.out.print("<--" + node.getNodeValue() + "-->");
            break;
        }
        case Node.ELEMENT_NODE: {
            System.out.print('<' + node.getNodeName());
            NamedNodeMap nnm = node.getAttributes();
            if (nnm != null) {
                int len = nnm.getLength();
                Attr attr;
                for (int i = 0; i < len; i++) {
                    attr = (Attr) nnm.item(i);
                    System.out.print(' ' + attr.getNodeName() + "=\""
                            + attr.getNodeValue() + '"');
                }
            }
            System.out.print('>');

            break;

        }//end of element
        case Node.ENTITY_REFERENCE_NODE: {

            System.out.print('&' + node.getNodeName() + ';');
            break;

        }//end of entity
        case Node.CDATA_SECTION_NODE: {
            System.out.print("<![CDATA[" + node.getNodeValue() + "]]>");
            break;

        }
        case Node.TEXT_NODE: {
            System.out.print(node.getNodeValue());
            break;
        }
        case Node.PROCESSING_INSTRUCTION_NODE: {
            System.out.print("<?" + node.getNodeName());
            String data = node.getNodeValue();
            if (data != null && data.length() > 0) {
                System.out.print(' ');
                System.out.print(data);
            }
            System.out.println("?>");
            break;

        }
        }//end of switch

        //recurse
        for (Node child = node.getFirstChild(); child != null; child = child
                .getNextSibling()) {
            walk(child);
        }

        //without this the ending tags will miss
        if (type == Node.ELEMENT_NODE) {
            System.out.print("</" + node.getNodeName() + ">");
        }
    }

    /**
     * xml_all_named(@Node,@Name,-NodeList): returns all descendants of Node (a
     * Document or an Element) named Name <font color="Red">Optimaler met
     * dom4j!!! </font>
     * 
     * @param document
     * @param name
     * @param nodeList
     * @return
     */
    public boolean xml_all_named_3(Struct name, Struct node, Var nodeList) {
        if (node.isAtom() && name.isAtom()) {
            Object docObj = TUPrologDynamicMapping.mapToJava(node, getEngine());

            Object strObj = TUPrologDynamicMapping.mapToJava(name, getEngine());
            if (!(strObj instanceof String))
                return false;
            String str = (String) strObj;

            NodeList map = null;

            if (docObj instanceof Document)
                map = ((Document) docObj).getElementsByTagName(str);
            else if (docObj instanceof Element)
                map = ((Element) docObj).getElementsByTagName(str);            
            
            if (map != null) {
                Object[] row = new Object[map.getLength()];
                for (int i = map.getLength() - 1; i >= 0; i--) {
                    row[i] = map.item(i);
                }
                return unify(nodeList, TUPrologDynamicMapping.mapToTuProlog(
                        row, getEngine()));
            } else
                return unify(nodeList, TUPrologDynamicMapping.mapToTuProlog(
                        null, getEngine()));
        } else
            return false;
    }

    /**
     * xml_append_child(@NewChild,@Parent): append NewChild to Parent's children
     * 
     * @param newChild
     * @param parent
     * @return
     */
    public boolean xml_append_child_2(Struct newChild, Struct parent) {
        if (newChild.isAtom() && parent.isAtom()) {
            Object newObj = TUPrologDynamicMapping.mapToJava(newChild,
                    getEngine());
            if (!(newObj instanceof Node))
                return false;
            Node newNode = (Node) newObj;

            Object parObj = TUPrologDynamicMapping.mapToJava(parent,
                    getEngine());
            if (!(parObj instanceof Node))
                return false;
            Node parNode = (Node) parObj;

            //first null-tests unnecessary?
            if ((newNode == null) || (parNode == null)
                    || (newNode.getParentNode() != null))
                return false;

            parNode.appendChild(newNode);
            return true;
        } else
            return false;
    }

    /**
     * xml_children(@Parent,-ChildrenList): get Parent's Children
     * 
     * @param parent
     * @param childrenList
     * @return
     */
    public boolean xml_children_2(Struct parent, Var childrenList) {
        if (parent.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping.mapToJava(parent,
                    getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            NodeList map = nodeNode.getChildNodes();

            Object[] res = new Object[map.getLength()];
            for (int i = map.getLength() - 1; i >= 0; i--) {
                res[i] = map.item(i);
            }

            return unify(childrenList, TUPrologDynamicMapping.mapToTuProlog(
                    res, getEngine()));

        } else
            return false;
    }

    /**
     * xml_clone(@Node,-Clone): clone Node to Clone
     * 
     * @param node
     * @param clone
     * @return
     */
    public boolean xml_clone_2(Struct node, Var clone) {
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());

            if (!(nodeObj instanceof Node))
                return false;
            
            Node nodeNode = (Node) nodeObj;

            Node cloneNode = nodeNode.cloneNode(true);
            return unify(clone, TUPrologDynamicMapping.mapToTuProlog(cloneNode,
                    getEngine()));

        } else
            return false;
    }

    /**
     * xml_first(@Node,?FirstSibling): check whether FirstSibling is Node's
     * first sibling
     * 
     * @param node
     * @param firstSibling
     * @return
     */
    public boolean xml_first_2(Struct node, Term firstSibling) {
        if (node == null || firstSibling == null)
            return false;
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            if (firstSibling.isAtom()) { //check if they are related
                Object firstSiblingObj = TUPrologDynamicMapping.mapToJava(
                        firstSibling, getEngine());
                if (!(firstSiblingObj instanceof Node))
                    return false;
                Node firstSiblingNode = (Node) firstSiblingObj;

                return nodeNode.getParentNode().getFirstChild() == firstSiblingNode;
            } else { //unify firstSibling with node's firstSibling
                return unify(firstSibling, TUPrologDynamicMapping
                        .mapToTuProlog(
                                nodeNode.getParentNode().getFirstChild(),
                                getEngine()));
            }
        } else
            return false;//there must be a bound argument!
    }

    /**
     * xml_first_child(?Parent,?Child): check whether Child is first child node
     * of Parent (at least one of them should be ground term)
     * 
     * @param parent
     * @param child
     * @return
     */
    public boolean xml_first_child_2(Term parent, Term child) {
        if (parent == null || child == null)
            return false;
        if (parent.isAtom()) {
            Object parentObj = TUPrologDynamicMapping.mapToJava(parent,
                    getEngine());
            if (!(parentObj instanceof Node))
                return false;
            Node parentNode = (Node) parentObj;

            if (child.isAtom()) { //check if they are related
                Object childObj = TUPrologDynamicMapping.mapToJava(child,
                        getEngine());
                if (!(childObj instanceof Node))
                    return false;
                Node childNode = (Node) childObj;

                return parentNode.getFirstChild() == childNode;
            } else { //unify child with parent's child
                return unify(child, TUPrologDynamicMapping.mapToTuProlog(
                        parentNode.getFirstChild(), getEngine()));
            }
        } else if (child.isAtom()) { //unify parent with child's parent
            Object childObj = TUPrologDynamicMapping.mapToJava(child,
                    getEngine());
            if (!(childObj instanceof Node))
                return false;
            Node childNode = (Node) childObj;

            Node parentNode = childNode.getParentNode();
            return (parentNode.getFirstChild() == childNode)
                    && unify(parent, TUPrologDynamicMapping.mapToTuProlog(
                            parentNode, getEngine()));
        } else
            return false;//there must be a bound argument!
    }

    /**
     * xml_from_file(@FileName,?DomTree): reads in XML-file as DOM-tree <font
     * color="Red">Relative file names are biased on the lillambi-root
     * directory. </font>
     * 
     * @param fileName
     * @param domTree
     * @return
     */
    public boolean xml_from_file_2(Struct fileName, Var domTree) {
        if (!fileName.isAtom())
            return false;

        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        //factory.setValidating(true);
        //factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(Tools.removeApices(fileName
                    .toString())));
            doc.normalize();
            return unify(domTree, TUPrologDynamicMapping.mapToTuProlog(doc,
                    getEngine()));
        } catch (SAXException sxe) {
            // Error generated during parsing)
            Exception x = sxe;
            if (sxe.getException() != null)
                x = sxe.getException();
            x.printStackTrace();

        } catch (ParserConfigurationException pce) {
            // Parser with specified options can't be built
            pce.printStackTrace();

        } catch (IOException ioe) {
            // I/O error
            ioe.printStackTrace();
        }
        return false;
    }

    /**
     * xml_is_leaf(@Leaf): check whether Leaf is a leaf XML-node
     * 
     * @param leaf
     * @return
     */
    public boolean xml_is_leaf_1(Struct leaf) {
        if (leaf.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(leaf, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            return !nodeNode.hasChildNodes();
        } else
            return false;
    }

    /**
     * xml_is_root(@Root): check whether Leaf is the root XML-node
     * 
     * @param root
     * @return
     */
    public boolean xml_is_root_1(Struct root) {
        if (root.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(root, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            return (nodeNode.getParentNode() == null);
        } else
            return false;
    }

    /**
     * xml_first(@Node,?LastSibling): check whether LastSibling is Node's last
     * sibling
     * 
     * @param node
     * @param lastSibling
     * @return
     */
    public boolean xml_last_2(Struct node, Term lastSibling) {
        if (node == null || lastSibling == null)
            return false;
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            if (lastSibling.isAtom()) { //check if they are related
                Object lastSiblingObj = TUPrologDynamicMapping.mapToJava(
                        lastSibling, getEngine());
                if (!(lastSiblingObj instanceof Node))
                    return false;
                Node lastSiblingNode = (Node) lastSiblingObj;

                return nodeNode.getParentNode().getLastChild() == lastSiblingNode;
            } else { //unify firstSibling with node's firstSibling
                return unify(lastSibling, TUPrologDynamicMapping.mapToTuProlog(
                        nodeNode.getParentNode().getLastChild(), getEngine()));
            }
        } else
            return false;//there must be a bound argument!
    }

    /**
     * xml_last_child(?Parent,?Child): check whether Child is last child node of
     * Parent (at least one of them should be ground term)
     * 
     * @param parent
     * @param child
     * @return
     */
    public boolean xml_last_child_2(Term parent, Term child) {
        if (parent == null || child == null)
            return false;
        if (parent.isAtom()) {
            Object parentObj = TUPrologDynamicMapping.mapToJava(parent,
                    getEngine());
            if (!(parentObj instanceof Node))
                return false;
            Node parentNode = (Node) parentObj;

            if (child.isAtom()) { //check if they are related
                Object childObj = TUPrologDynamicMapping.mapToJava(child,
                        getEngine());
                if (!(childObj instanceof Node))
                    return false;
                Node childNode = (Node) childObj;

                return parentNode.getLastChild() == childNode;
            } else { //unify child with parent's child
                return unify(child, TUPrologDynamicMapping.mapToTuProlog(
                        parentNode.getLastChild(), getEngine()));
            }
        } else if (child.isAtom()) { //unify parent with child's parent
            Object childObj = TUPrologDynamicMapping.mapToJava(child,
                    getEngine());
            if (!(childObj instanceof Node))
                return false;
            Node childNode = (Node) childObj;

            Node parentNode = childNode.getParentNode();
            return (parentNode.getLastChild() == childNode)
                    && unify(parent, TUPrologDynamicMapping.mapToTuProlog(
                            parentNode, getEngine()));
        } else
            return false;//there must be a bound argument!
    }

    /**
     * xml_make_comment(@Document,@String,-CommentNode): create CommentNode in
     * Document, containing String as comment
     * 
     * @param document
     * @param string
     * @param commentNode
     * @return
     */
    public boolean xml_make_comment_3(Struct document, Struct string,
            Var commentNode) {
        if (document.isAtom() && string.isAtom()) {
            Object docObj = TUPrologDynamicMapping.mapToJava(document,
                    getEngine());
            if (!(docObj instanceof Document))
                return false;
            Document doc = (Document) docObj;

            Object strObj = TUPrologDynamicMapping.mapToJava(string,
                    getEngine());
            if (!(strObj instanceof String))
                return false;
            String str = (String) strObj;

            Node res = doc.createComment(str);
            return unify(commentNode, TUPrologDynamicMapping.mapToTuProlog(res,
                    getEngine()));
        } else
            return false;
    }

    /**
     * xml_make_element(@Document,@Name,-ElementNode): create ElementNode with
     * tag name Name in Document
     * 
     * @param document
     * @param name
     * @param elementNode
     * @return
     */
    public boolean xml_make_element_3(Struct document, Struct name,
            Var elementNode) {
        if (document.isAtom() && name.isAtom()) {
            Object docObj = TUPrologDynamicMapping.mapToJava(document,
                    getEngine());
            if (!(docObj instanceof Document))
                return false;
            Document doc = (Document) docObj;

            Object strObj = TUPrologDynamicMapping.mapToJava(name, getEngine());
            if (!(strObj instanceof String))
                return false;
            String str = (String) strObj;

            Node res = doc.createElement(str);
            return unify(elementNode, TUPrologDynamicMapping.mapToTuProlog(res,
                    getEngine()));
        } else
            return false;
    }

    /**
     * xml_make_text(@Document,@String,-TextNode): create TextNode in Document,
     * containing String as text
     * 
     * @param document
     * @param string
     * @param textNode
     * @return
     */
    public boolean xml_make_text_3(Struct document, Struct string, Var textNode) {
        if (document.isAtom() && string.isAtom()) {
            Object docObj = TUPrologDynamicMapping.mapToJava(document,
                    getEngine());
            if (!(docObj instanceof Document))
                return false;
            Document doc = (Document) docObj;

            Object strObj = TUPrologDynamicMapping.mapToJava(string,
                    getEngine());
            if (!(strObj instanceof String))
                return false;
            String str = (String) strObj;

            Node res = doc.createTextNode(str);
            return unify(textNode, TUPrologDynamicMapping.mapToTuProlog(res,
                    getEngine()));
        } else
            return false;
    }

    /**
     * xml_name(@Node,?Name): check whether Name contains the name of Node
     * 
     * @param node
     * @param name
     * @return
     */
    public boolean xml_name_2(Struct node, Term name) {
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            String nodeName = nodeNode.getNodeName();

            return unify(name, TUPrologDynamicMapping.mapToTuProlog(nodeName,
                    getEngine()));
        } else
            return false;
    }

    /**
     * xml_next(?Prev,?Next): check whether Prev is previous sibling of Next (at
     * least one of them should be ground term)
     * 
     * @param prev
     * @param next
     * @return
     */
    public boolean xml_next_2(Term prev, Term next) {
        if (prev == null || next == null)
            return false;
        if (prev.isAtom()) {
            Object prevObj = TUPrologDynamicMapping
                    .mapToJava(prev, getEngine());
            if (!(prevObj instanceof Node))
                return false;
            Node prevNode = (Node) prevObj;

            if (next.isAtom()) { //check if they are related
                Object nextObj = TUPrologDynamicMapping.mapToJava(next,
                        getEngine());
                if (!(nextObj instanceof Node))
                    return false;
                Node nextNode = (Node) nextObj;

                return prevNode.getNextSibling() == nextNode;
            } else { //unify child with parent's child
                return unify(next, TUPrologDynamicMapping.mapToTuProlog(prevNode.getNextSibling(), getEngine()));
            }
        } else if (next.isAtom()) { //unify parent with child's parent
            Object nextObj = TUPrologDynamicMapping
                    .mapToJava(next, getEngine());
            if (!(nextObj instanceof Node))
                return false;
            Node nextNode = (Node) nextObj;

            return unify(prev, TUPrologDynamicMapping.mapToTuProlog(nextNode
                    .getPreviousSibling(), getEngine()));
        } else
            return false;//there must be a bound argument!
    }

    /**
     * xml_owner(@Node,?Owner): get the Document which is Owner of Node
     * 
     * @param node
     * @param name
     * @return
     */
    public boolean xml_owner_2(Struct node, Term owner) {
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            Document ownerNode = nodeNode.getOwnerDocument();
            if (ownerNode == null)
                return false;//cf. PRED_xml_owner_2

            if (owner.isAtom()) { //ground-var (here if-else is needed <-->
                                  // xml_name, xml_type & xml_value: not needed)
                Object ownerObj = TUPrologDynamicMapping.mapToJava(owner,
                        getEngine());
                if (!(ownerObj instanceof Document))
                    return false;
                Document docOwner = (Document) ownerObj;

                return ownerNode.equals(docOwner);
            } else { //ground-ground
                return unify(owner, TUPrologDynamicMapping.mapToTuProlog(
                        ownerNode, getEngine()));
            }
        } else
            return false;
    }

    /**
     * xml_parent(@Node,?Parent): get Node's Parent
     * 
     * @param node
     * @param parent
     * @return
     */
    public boolean xml_parent_2(Struct node, Term parent) {
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            Node parentNode = nodeNode.getParentNode();
            if (parentNode == null)
                return false;//cf. PRED_xml_parent_2

            if (parent.isAtom()) { //ground-var (here if-else is needed <-->
                                   // xml_name, xml_type & xml_value: not
                                   // needed)
                Object parentObj = TUPrologDynamicMapping.mapToJava(parent,
                        getEngine());
                if (!(parentObj instanceof Document))
                    return false;
                Document docParent = (Document) parentObj;

                return parentNode.equals(docParent);
            } else { //ground-ground
                return unify(parent, TUPrologDynamicMapping.mapToTuProlog(
                        parentNode, getEngine()));
            }
        } else
            return false;
    }

    /**
     * xml_prepend(@NodeToPrepend,@NextSiblingOfNodeToPrepend): prepend
     * NodeToPrepend before NextSiblingOfNodeToPrepend
     * 
     * @param nodeToPrepend
     * @param nextSiblingOfNodeToPrepend
     * @return
     */
    public boolean xml_prepend_2(Struct nodeToPrepend,
            Struct nextSiblingOfNodeToPrepend) {
        if (nodeToPrepend.isAtom() && nextSiblingOfNodeToPrepend.isAtom()) {
            Object prepObj = TUPrologDynamicMapping.mapToJava(nodeToPrepend,
                    getEngine());
            if (!(prepObj instanceof Node))
                return false;
            Node prepNode = (Node) prepObj;

            if (prepNode == null)
                return false;

            Object sibObj = TUPrologDynamicMapping.mapToJava(
                    nextSiblingOfNodeToPrepend, getEngine());
            if (!(sibObj instanceof Node))
                return false;
            Node sibNode = (Node) sibObj;//allowed to be null: prepNode could
                                         // be added as last child

            Node parent = sibNode.getParentNode();
            if (parent == null)
                return false;

            parent.insertBefore(prepNode, sibNode);
            return true;
        } else
            return false;
    }

    /**
     * xml_print_DOM(@DOM_tree): prints DOM_tree to stdout
     * 
     * @param domTree
     * @return
     */
    public boolean xml_print_DOM_1(Struct domTree) {
        if (!domTree.isAtom())
            return false;

        Object obj = TUPrologDynamicMapping.mapToJava(domTree, getEngine());
        if (!(obj instanceof Node))
            return false;
        Node node = (Node) obj;

        walk(node);
        return true;
    }

    /**
     * xml_remove(@XMLNode): remove XMLNode from the containing XML-tree
     * 
     * @param xmlNode
     * @return
     */
    public boolean xml_remove_1(Struct xmlNode) {
        if (!xmlNode.isAtom())
            return false;//Java-object wordt voorgesteld door atoom

        Object obj = TUPrologDynamicMapping.mapToJava(xmlNode, getEngine());
        if (!(obj instanceof Node))
            return false;
        Node node = (Node) obj;

        Node parent = node.getParentNode();
        if (parent != null) {
            parent.removeChild(node);
        }
        return true;
    }

    /**
     * xml_swap(@OldChild,@NewChild): replaces OldChild in its containing XML tree with NewChild
     * @param OldChild
     * @param NewChild
     * @return
     */
    public boolean xml_swap_2(Struct oldChild, Struct newChild) {
        if (oldChild.isAtom() && newChild.isAtom()) {
            Object oldObj = TUPrologDynamicMapping.mapToJava(oldChild,
                    getEngine());
            if (!(oldObj instanceof Node))
                return false;
            Node oldNode = (Node) oldObj;

            Object newObj = TUPrologDynamicMapping.mapToJava(newChild,
                    getEngine());
            if (!(newObj instanceof Node))
                return false;
            Node newNode = (Node) newObj;

            Node parent = oldNode.getParentNode();
            if (parent == null)
                return false;

            parent.replaceChild(newNode, oldNode);

            return true;
        } else
            return false;
    }

    /**
     * xml_to_file(@FileName,@DomTree): writes DomTree to XML-file <font
     * color="Red">Relative file names are biased on the lillambi-root
     * directory. </font>
     * 
     * @param fileName
     * @param domTree
     * @return
     */
    public boolean xml_to_file_2(Struct fileName, Struct domTree) {
        if (!fileName.isAtom() || !domTree.isAtom())
            return false;
        else {
            Object fileObj = TUPrologDynamicMapping.mapToJava(fileName,
                    getEngine());
            if (!(fileObj instanceof String))
                return false;
            String fileString = (String) fileObj;

            Object nodeObj = TUPrologDynamicMapping.mapToJava(domTree,
                    getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            if ((fileString == null) || (nodeNode == null))
                return false;//unnecessary?

            try {
                Transformer transformer = TransformerFactory.newInstance()
                        .newTransformer();
                transformer.transform(new DOMSource(nodeNode),
                        new StreamResult(new File(fileString)));

                return true;

            } catch (Exception e) {
                // e.printStackTrace ();
                return false;
            }
        }
    }

    /**
     * xml_type(@Node,?Type): get Node's Type
     * 
     * @param node
     * @param type
     * @return
     */
    public boolean xml_type_2(Struct node, Term type) {
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            int nodeType = nodeNode.getNodeType();

            //no if-else needed here (<--> xml_parent & xml_owner)
            return unify(type, TUPrologDynamicMapping.mapToTuProlog(
                    new Integer(nodeType), getEngine()));
        } else
            return false;
    }

    /**
     * xml_value(@Node,?Value): check whether Value contains the value of Node
     * 
     * @param node
     * @param value
     * @return
     */
    public boolean xml_value_2(Struct node, Term value) {
        if (node.isAtom()) {
            Object nodeObj = TUPrologDynamicMapping
                    .mapToJava(node, getEngine());
            if (!(nodeObj instanceof Node))
                return false;
            Node nodeNode = (Node) nodeObj;

            String name = nodeNode.getNodeValue();

            if (name == null)
                name = "";
            else {
                try {
                    name = java.net.URLDecoder.decode(name, "UTF-8");
                } catch (java.io.UnsupportedEncodingException uee) {
                }
            }
            /*
             * if(value.isAtom()) { //no if-else needed here ( <--> xml_parent &
             * xml_owner) Object
             * valueObj=TUPrologDynamicMapping.mapToJava(value,getEngine());
             * if(!String.class.isAssignableFrom(valueObj.getClass())) return
             * false; String valueString=(String)valueObj;
             * 
             * return name.equals(valueString); }else{
             */
            return unify(value, TUPrologDynamicMapping.mapToTuProlog(name,
                    getEngine()));
            //}
        } else
            return false;
    }
}
