/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 19-nov-2004
 *
 */
package be.ugent.ftw.intec.sel.lillambi.agents;

import java.util.Iterator;

import alice.tuprolog.Int;
import alice.tuprolog.Number;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.tuprolog.lib.InvalidObjectIdException;
import alice.tuprolog.lib.JavaLibrary;

/**
 * @author bram
 *
 * 19-nov-2004
 */
public class TUPrologStaticMapping {
    //private static int count = 0;
    
    public static Term mapToTuProlog (Object a,Prolog engine) {
        JavaLibrary java = (JavaLibrary) engine.getLibrary ("alice.tuprolog.lib.JavaLibrary");
        
        if (a == null) {
          return new Struct("nil");
        
        } else if (a instanceof String) {
            return new Struct ((String) a);

        } else if (a instanceof Integer) {
            return new Int (((Integer) a).intValue ());

        } else if (a instanceof java.lang.Float) {
            return new alice.tuprolog.Float (((java.lang.Float) a)
                    .floatValue ());

        } else if (a instanceof java.lang.Long) {
            return new alice.tuprolog.Long (((java.lang.Long) a)
                    .longValue ());

        } else if (a instanceof java.lang.Double) {
            return new alice.tuprolog.Double (((java.lang.Double) a)
                    .doubleValue ());

        } else if (a.getClass ().isArray ()) {
            return mapToTuProlog ((Object[]) a,engine);

        } else {
            //Struct id = null;
            //try {
                /*int ref;
                synchronized (java) {
                    ref = count++;
                } */              
                //boolean test=java.register (id = new Struct ("$lils_" + ref), a);
                //if(ref==152)System.err.println("152!!!!!! "+test+" -> "+a);
                return java.register(a);
                //System.err.print(id+" ");// + " -> " + a);
                //return id;
            /*} catch (InvalidObjectIdException e) {
                e.printStackTrace ();
                return null;
            }*/
        }        
    }
    
    public static Struct mapToTuProlog (Object[] args,Prolog engine) {
        if (args == null)
          return new Struct ("nil");

        JavaLibrary java = (JavaLibrary) engine.getLibrary ("alice.tuprolog.lib.JavaLibrary");
        Term[] terms = new Term[args.length];

        for (int i = 0; i < args.length; i++) {
            terms[i] = mapToTuProlog(args[i],engine);            
        }

        return new Struct (terms);
    }

    public static Object mapToJava (Term term,Prolog engine) {
        JavaLibrary java = (JavaLibrary) engine
        .getLibrary ("alice.tuprolog.lib.JavaLibrary");
        if (term.isList ()) {
            return mapListToJava (term,engine);

        } else if (term.isNumber ()) {
            Number number = (Number) term;
            if (number.isTypeDouble ())
                return new java.lang.Double (number.doubleValue ());
            else if (number.isTypeFloat ())
                return new java.lang.Float (number.floatValue ());
            else if (number.isTypeLong ())
                return new java.lang.Long (number.longValue ());
            else
                return new java.lang.Integer (number.intValue ());

        } else if (term.isAtom ()) {
            Struct struct = (Struct) term;
            try {
                if(struct.getName().equals("nil")) return null;
                Object object=java.getRegisteredObject(struct);
                if (object != null){
                    return object;
                }
                
                object = java.getRegisteredDynamicObject(struct);

                if (object != null){
                    return object;
                }
                return struct.getName();

            } catch (InvalidObjectIdException e) {
                return struct.getName ();
            }

        } else if (term.isVar ()) {
            Var var = (Var) term;
            if (var.getName ().equals ("_"))
                return null;
        }

        return null;
    }

    public static Object[] mapListToJava (Term term,Prolog engine) {
        if(term.isAtom()&&((Struct)term).getName().equals("nil")) return null;
        if (term.isList ()) {
            Struct list = (Struct) term;
            Object[] objects = new Object[list.listSize ()];

            int i = 0;
            for (Iterator iter = list.listIterator (); iter.hasNext (); i++) {
                Term item = (Term) iter.next ();
                objects[i] = mapToJava (item,engine);
            }
            return objects;
        }

        return null;
    }
}
