/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 19-nov-2004
 *
 */
package be.ugent.ftw.intec.sel.lillambi.agents;

import alice.tuprolog.Int;
import alice.tuprolog.Library;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;

/**
 * 2Prolog-lib for String-actions.
 * @author bram
 *
 * 19-nov-2004
 */
public class TUPrologStringLibrary extends Library {

    public TUPrologStringLibrary() {
        super();
    }
    
    /**
     * str_cat(@List, -Res): concatenate all list elements
     * @param list
     * @param res
     * @return
     */
    public boolean str_cat_2(Struct list,Var res){
        if(!list.isList()) return false;                
        
        if (list.isEmptyList()){
            return (unify(res,new Struct("")));
        }

        String st="";
        while (!(list.isEmptyList())){
            st=st.concat(TUPrologDynamicMapping.mapToJava(list.getTerm(0),getEngine()).toString());
            list=(Struct)list.getTerm(1);
        }
        return (unify(res,new Struct(st)));
    }
    
    /**
     * str_err_println(@String): prints String on stderr
     * @param string
     * @return
     */
    public boolean str_err_println_1(Struct string){
        if(!string.isAtom()) return false;
        System.err.println(TUPrologDynamicMapping.mapToJava(string,getEngine()));
        return true;
    }
    
    /**
     * str_int(@Symbol,-Res): parse '...'-string to integer
     * @return
     */
    public boolean str_int_2(Struct symbol,Var res){
        if(!symbol.isAtom()) return false;
        return (unify(res,new Int(Integer.parseInt(((String)TUPrologDynamicMapping.mapToJava(symbol,getEngine()))))));
    }
    
    /**
     * str_is_whitespace(@Symbol): is Symbol made up entirely of whitespace?
     * @param symbol
     */
    public boolean str_is_whitespace_1(Struct symbol){
        if(!symbol.isAtom()) return false;
        return ((String)TUPrologDynamicMapping.mapToJava(symbol,getEngine())).matches("\\s*");
    }
    
    /**
     * str_matches(@Reg_exp,@Text): does Text match with regular expression Reg_exp?
     * @param regExp
     * @param text
     * @return
     */
    public boolean str_matches_2(Struct regExp,Struct text){
        if(!regExp.isAtom()||!text.isAtom()) return false;
        return ((String)TUPrologDynamicMapping.mapToJava(text,getEngine())).matches(((String)TUPrologDynamicMapping.mapToJava(regExp,getEngine())));
    }
    
    /**
     * str_out_println(@String): prints String on stdout
     * @param string
     * @return
     */
    public boolean str_out_println_1(Struct string){
        if(!string.isAtom()) return false;
        System.out.println(TUPrologDynamicMapping.mapToJava(string,getEngine()));
        return true;
    }
    
    /**
     * str_trim(@Symbol, -Res): remove spurious white space from '...'-string
     * @param symbol
     * @param res
     * @return
     */
    public boolean str_trim_2(Struct symbol,Var res){
        if(!symbol.isAtom()) return false;
        return unify(res,new Struct(((String)TUPrologDynamicMapping.mapToJava(symbol,getEngine())).trim()));
    }
    
    /**
     * str_stringify(?Text, ?StrText): StrText.equals("\""+Text+"\"")
     * @param symbol
     * @param res
     * @return
     */
    public boolean str_stringify_2(Term text,Term strText){
        if(text.isAtom()){
        	String textValue=((Object)TUPrologDynamicMapping.mapToJava(text,getEngine())).toString();
        	if(strText.isAtom()){
        		String strTextValue=((Object)TUPrologDynamicMapping.mapToJava(strText,getEngine())).toString();
        		return strTextValue.equals("\""+textValue+"\"");
        	}else return unify(strText,new Struct("\""+textValue+"\""));
        }else if(strText.isAtom()){
    		String strTextValue=((Object)TUPrologDynamicMapping.mapToJava(strText,getEngine())).toString();
    		if(strTextValue.matches("^\".*\"$")) return unify(text,new Struct(strTextValue.substring(1,strTextValue.length()-1)));
    		else return false;
        }else return false;       
    }
}
