/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 19-nov-2004
 *
 */
package be.ugent.ftw.intec.sel.lillambi.agents;

import java.util.HashSet;
import java.util.Set;

import alice.tuprolog.Library;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;

/**
 * @author bram
 *
 * 19-nov-2004
 */
public class TUPrologSystemLibrary extends Library {

    /**
     * 
     */
    public TUPrologSystemLibrary() {
        super();
    }
    
    /**
     * sys_variable(@Symbol,-Res): retrieve value of system variable Symbol and unify with Res
     * @param symbol
     * @param res
     * @return
     */
    public boolean sys_variable_2(Struct symbol,Var res){
        if(!symbol.isAtom()) return false;
        String val=System.getProperty(((String)TUPrologDynamicMapping.mapToJava(symbol,getEngine())));
        if(val==null) return false;
        else return unify(res,new Struct(val));
    }
    
    /**
     * sys_instanceof(@Object,?SuperNames): retrieve Object's [direct super-interfaces and -class]
     * @param symbol
     * @param res
     * @return
     */
    public boolean sys_instanceof_2(Struct object,Term superNames){
        if(!object.isAtom()) return false;
        Object obj=TUPrologStaticMapping.mapToJava(object,getEngine());
        if(obj==null)return false;//no Java Object!
        Class objClass=obj.getClass();

        //verzamel alle supers
        Set classNames=new HashSet();
        classNames.add(objClass.getName());
        Class superClass=objClass.getSuperclass();
        if(superClass!=null)classNames.add(superClass.getName());
        classNames.addAll(getAllSuperInterfaces(objClass));
        
        if(superNames.isVar()||superNames.isStruct()) return unify(superNames, TUPrologDynamicMapping.mapToTuProlog(classNames.toArray(), getEngine()));
        else return false;
    }
    
    static Set getAllSuperInterfaces(Class cla){
    	Class[] tmp=cla.getInterfaces();
    	Set res=new HashSet();
    	for(int i=0;i<tmp.length;i++){
    		res.add(tmp[i].getName());
    		res.addAll(getAllSuperInterfaces(tmp[i]));
    	}
    	return res;
    }
    
    

}
