/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package be.ugent.ftw.intec.sel.lillambi.agents;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.InvalidVarNameException;
import alice.tuprolog.NoSolutionException;
import alice.tuprolog.OutputEvent;
import alice.tuprolog.OutputListener;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.SpyEvent;
import alice.tuprolog.SpyListener;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.UnknownVarException;
import alice.tuprolog.Var;
import alice.tuprolog.lib.JavaLibrary;
import be.ugent.ftw.intec.sel.lillambi.Agent;
import be.ugent.ftw.intec.sel.lillambi.AgentException;
import be.ugent.ftw.intec.sel.lillambi.Lillambi;


public class TuPrologAgent implements Agent {
    private static Theory tools;
    private static PrintWriter writer;
    
    static {
        try {
            tools=new Theory(new BufferedInputStream (new FileInputStream (Lillambi.getRoot()+"lib/tools.pl")));
        } catch (InvalidTheoryException e) {
            System.err.println("TUPrologAgent: tools theory has errors.");
            System.exit(Lillambi.AGENT_CLASS_INIT_ERROR);
        } catch (FileNotFoundException e) {
            System.err.println("TUPrologAgent: tools theory not found.");
            System.exit(Lillambi.AGENT_CLASS_INIT_ERROR);
        } catch (IOException e) {
            System.err.println("TUPrologAgent: error reading tools theory.");
            System.exit(Lillambi.AGENT_CLASS_INIT_ERROR);
        }
        
        File spyFile=new File(Lillambi.getRoot()+"spylog.txt");
        spyFile.delete();
        try {
            writer=new PrintWriter(new BufferedWriter(new FileWriter(spyFile)));
        } catch (IOException e1) {
            System.err.println("Error initializing spylistener!");
            e1.printStackTrace();
        }
    }
    
    private Theory theory;
    

    TuPrologAgent (Theory theory){
        this.theory=theory;
    }

    public Object[] act (Object[] args) throws AgentException {
        Prolog engine=new Prolog();        
        engine.addOutputListener (new OutputListener () {
            public void onOutput (OutputEvent ev) {
                String msg = ev.getMsg ();
                if (msg.charAt (0) == '\''
                        && msg.charAt (msg.length () - 1) == '\'')
                    msg = msg.substring (1, msg.length () - 1);
                System.out.print (msg);
            }
        });
        engine.addSpyListener(new SpyListener(){
            /**
             * @see alice.tuprolog.SpyListener#onSpy(alice.tuprolog.SpyEvent)
             */
            public void onSpy(SpyEvent ev) {
                String msg = ev.getMsg ();
                if (msg.charAt (0) == '\''
                        && msg.charAt (msg.length () - 1) == '\'')
                    msg = msg.substring (1, msg.length () - 1);
                writer.write(msg+"\n");
                writer.flush();
            }
        });

        try {
            engine.setTheory(tools);
            engine.addTheory (theory);
        } catch (InvalidTheoryException e1) {
            e1.printStackTrace();
            throw new AgentException(e1);
        }
        
        try {
            Struct terms = TUPrologStaticMapping.mapToTuProlog (args,engine);
            Struct goal = new Struct ("act", terms, new Var ("X"));            
            SolveInfo info = engine.solve (goal);

            if (!info.isSuccess ())
                return null;

            Term returnValue = info.getTerm ("X");
            Object[] returnVals = TUPrologStaticMapping.mapListToJava (returnValue,engine);
            ((JavaLibrary) engine.getLibrary ("alice.tuprolog.lib.JavaLibrary")).dismissAll (); // TODO : hack
            return returnVals;

        } catch (NoSolutionException e) {
            throw new AgentException (
                    "TuPrologAgent could not find an answer.", e);
        } catch (InvalidVarNameException e) {
            throw new AgentException (
                    "TuPrologAgent acting up -without reason- "
                            + "over some invalid variable name.", e);
        } catch (UnknownVarException e) {
            throw new AgentException (
                    "TuPrologAgent acting up -without reason- "
                            + "over some unknown variable name.", e);
        } finally{
            writer.close();
        }
    }


}
