/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package be.ugent.ftw.intec.sel.lillambi.agents;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import be.ugent.ftw.intec.sel.lillambi.Agent;
import be.ugent.ftw.intec.sel.lillambi.AgentNotLoaded;
import be.ugent.ftw.intec.sel.lillambi.Factory;
import be.ugent.ftw.intec.sel.lillambi.Lillambi;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Theory;

public class TuPrologFactory implements Factory {

    static {
        Lillambi.addFactory (new TuPrologFactory ());
    }

    public Agent build (Properties props) throws AgentNotLoaded {
        String pathToAgent = props.getProperty ("lillambi.agent_path");
        String agentName = props.getProperty ("lillambi.agent_name");

        String location = props.getProperty ("agent.location");
        String filename = pathToAgent + location;

        try {
            InputStream is = new BufferedInputStream (new FileInputStream (
                    filename));
            Theory theory = new Theory (is);
            return new TuPrologAgent (theory);

        } catch (FileNotFoundException e) {
            throw new AgentNotLoaded ("Script for agent <" + agentName
                    + "> not found at <" + filename + ">.", e);

        } catch (InvalidTheoryException e) {
            throw new AgentNotLoaded ("Script for agent <" + agentName
                    + "> has errors.", e);

        } catch (IOException e) {
            throw new AgentNotLoaded ("IO error while reading script <"
                    + filename + "> for agent <" + agentName + ">.", e);
        }
    }
}
