#!/usr/bin/perl

# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Yerna Lindale.
#
# The Initial Developer of the Original Code is
# the Software Engineering Lab, INTEC, University Ghent.
# Portions created by the Initial Developer are Copyright (C) 2004
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Kris De Schutter <kris.deschutter@ugent.be>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

package PAL_Active_Rule_Finder;

require PAL;
require LLL;

# require Exporter;
# our @ISA = qw( Exporter );
# our @EXPORT_OK = qw( parse );

# ===================================================================
# Pretty printer...                                                 =
# ===================================================================

  sub new {
    my $class = shift;

    return bless {
      'active' => [],
      'active_by_default' => 0
    }, $class;
  }

  sub enter_pal_file {
    my $self = shift;
    my $node = $_[0];

    my $named_rules = {};
    foreach $rule (@{$node->{'rules'}}) {
      $named_rules->{$rule->{'name'}} = $rule;
    }
    
    my $active = $self->{'active'};
    foreach $starter (@{$node->{'starters'}}) {
      $active->[@{$active}] = $starter;
    }

    # Find the active rules...
    my $found = {};

    # For all starters (a growing list)...
    for (my $i = 0; $i < @{$active}; $i++) {
      # Get the rule name...
      my $the_name = $active->[$i];
      # If rule already found active, move on...
      if ($found->{$the_name}) { next; }
      # Find the rule...
      my $the_rule = $named_rules->{$the_name};
      # If not found we assume it to be an identifier of a token...
      if ($the_rule == 0) { next; }
      # If we get to this point, add the rule to the active ones...
      $found->{$the_name} = $the_rule;
      # Add bound names within the rule to the active list...
      $the_rule->accept ($self);
    }

    # Transfer the active rules to the list...
    $active = [];
    foreach $rule (values %{$found}) {
      $active->[@{$active}] = $rule;
    }
    $self->{'active'} = $active;

    return 0;
  }

  sub leave_pal_file {
    my $self = shift;
    my $node = $_[0];
  }

  sub enter_pal_rule {
    my $self = shift;
    my $node = $_[0];

    return 1;
  }

  sub leave_pal_rule {
  }

  sub enter_pal_disjunction {
    my $self = shift;
    my $node = $_[0];

    return 1;
  }

  sub leave_pal_disjunction {
    my $self = shift;
    my $node = $_[0];
  }

  sub enter_pal_conjunction {
    my $self = shift;
    my $node = $_[0];

    return 1;
  }

  sub leave_pal_conjunction {
    my $self = shift;
    my $node = $_[0];
  }

  sub enter_term {
    my $self = shift;
    my $node = $_[0];

    if (($self->{'active_by_default'} == 1)
      or (defined $node->{'binding'}) and ($node->{'binding'} ne '')) {
      # ACTIVE
      my $active = $self->{'active_by_default'};
      $self->{'active_by_default'} = 1;
      $node->{'basis'}->accept ($self);
      $self->{'active_by_default'} = $active;
    }

    return 0;
  }

  sub leave_term {
    my $self = shift;
    my $node = $_[0];
  }

  sub enter_disjunction {
    my $self = shift;
    my $node = $_[0];

    return 1;
  }

  sub leave_disjunction {
    my $self = shift;
    my $node = $_[0];
  }

  sub enter_conjunction {
    my $self = shift;
    my $node = $_[0];

    return 1;
  }

  sub leave_conjunction {
    my $self = shift;
    my $node = $_[0];
  }

  sub do_identifier {
    my $self = shift;
    my $node = $_[0];

    $self->{'active'}->[@{$self->{'active'}}] = $node->{'value'};
  }

  sub do_literal {
    my $self = shift;
    my $node = $_[0];
  }

  sub enter_rule {
    my $self = shift;
    my $node = $_[0];

    return 1;
  }

  sub leave_rule {
    my $self = shift;
    my $node = $_[0];
  }



1;
