/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Yerna Lindale.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.*;
import org.w3c.dom.*;

public class grab_source {
	public static void main(String args[]) {
		grab_source grabber = new grab_source();
		InputStream in = null;

		if (args.length == 0) {
			in = System.in;
		} else {
			try {
				in = new FileInputStream(new File(args[0]));
			} catch (FileNotFoundException e) {
				System.err
						.println("File does not exist, I think. Continuing with System.in ...");
				e.printStackTrace();
				in = System.in;
			}
		}

		grabber.translate(in);
	}

	private int depth = 0;

	private int indent = 0;

	public void translate(InputStream is) {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

		Document document = null;

		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.parse(new BufferedInputStream(is));
		} catch (SAXException exc) {
			if (exc.getException() != null)
				exc.getException().printStackTrace();
			else {
				/* System.err.println ("SAXException occured."); */
				exc.printStackTrace();
			}
			System.exit(1);
		} catch (ParserConfigurationException exc) {
			exc.printStackTrace();
			System.exit(1);
		} catch (IOException exc) {
			exc.printStackTrace();
			System.exit(1);
		}

		translate(document.getChildNodes());
		output_line();
	}

	public void translate(NodeList nodelist) {
		for (int i = 0; i < nodelist.getLength(); i++) {
			translate(nodelist.item(i));
		}
	}

	public void translate(Node node) {
		boolean processChildren = true;
		int indentationOffset = 0;
		boolean insertBlock = false;

		if (node.getNodeType() == Node.TEXT_NODE) {
			if (!node.getNodeValue().trim().equals("")) {
				output(node.getNodeValue());
			}

		} else if (node.getNodeType() == Node.COMMENT_NODE) {
			String layout = node.getNodeValue();
			if (layout.length() >= 2)
				layout = layout.substring(1, layout.length() - 1);
			int len = layout.length();

			if (len >= 3
					&& layout.substring(len - 3, len).compareTo(" @n") == 0) {
				output(unescape(layout.substring(0, len - 3)));
				output_line();
			} else {
				output(unescape(layout));
			}

		} else if (node.getNodeType() == Node.ELEMENT_NODE) {
			if (node.getNodeName().equals("yl_insert_block")) {
				insertBlock = true;
				indentationOffset = depth;
				indent += indentationOffset;
			}
		}

		if (processChildren)
			translate(node.getChildNodes());

		if (insertBlock) {
			output_line();
			indent -= indentationOffset;
		}
	}

	private void output(String s) {
		String[] split = s.split("\n", -1);
		System.out.print(split[0]);

		for (int i = 1; i < split.length; i++) {
			System.out.println();
			for (int j = 0; j < indent; j++)
				output(" ");
			System.out.print(split[i]);
		}

		if (split.length == 1)
			depth += split[0].length();
		else
			depth = split[split.length - 1].length();
	}

	private void output_line() {
		depth = 0;
		System.out.println();
		for (int i = 0; i < indent; i++)
			output(" ");
	}

	private String unescape(String text) {
		String unescaped = "";

		for (int i = 0; i < text.length(); i++) {
			char c = text.charAt(i);

			switch (c) {

			case '&':
				int j;
				for (j = i + 1; j < text.length(); j++) {
					char cj = text.charAt(j);

					if (cj == ';') {
						String entity = text.substring(i + 1, j);
						// unescaped += "[" + entity + "]";

						if (entity.equals("quot")) {
							unescaped += '\"';
						} else if (entity.equals("amp")) {
							unescaped += '&';
						} else if (entity.equals("lt")) {
							unescaped += '<';
						} else if (entity.equals("gt")) {
							unescaped += '>';
						} else if (entity.equals("dmin")) {
							unescaped += "--";
						} else {
							if (entity.charAt(0) == '#') {
								try {
									int ord = Integer.parseInt(entity
											.substring(1));
									char uc = (char) ((byte) (ord - 256));
									unescaped += uc;
								} catch (NumberFormatException e) {
									unescaped += '&' + entity + ';';
								}
							} else {
								unescaped += '&' + entity + ';';
							}
						}

						i = j;
						break;

					} else if (Character.isWhitespace(cj)) {
						unescaped += '&';
						break;
					}
				}

				if (j == text.length()) {
					unescaped += '&';
				}
				break;

			default:
				unescaped += c;
				break;
			}

		}

		return unescaped;
	}

}
