/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;

public class TriadicCensus {
    public static final String[] TRIAD_NAMES = new String[]{"N/A", "003", "012", "102", "021D", "021U", "021C", "111D", "111U", "030T", "030C", "201", "120D", "120U", "120C", "210", "300"};
    public static final int MAX_TRIADS = TRIAD_NAMES.length;
    protected static final int[] codeToType = new int[]{1, 2, 2, 3, 2, 4, 6, 8, 2, 6, 5, 7, 3, 8, 7, 11, 2, 6, 4, 8, 5, 9, 9, 13, 6, 10, 9, 14, 7, 14, 12, 15, 2, 5, 6, 7, 6, 9, 10, 14, 4, 9, 9, 12, 8, 13, 14, 15, 3, 7, 8, 11, 7, 12, 14, 15, 8, 14, 13, 15, 11, 15, 15, 16};

    public static long[] getCounts(DirectedGraph g) {
        long[] count = new long[MAX_TRIADS];
        Indexer id = Indexer.getIndexer(g);
        for (int i_v = 0; i_v < g.numVertices(); ++i_v) {
            Vertex v = (Vertex)id.getVertex(i_v);
            Iterator iter = v.getNeighbors().iterator();
            while (iter.hasNext()) {
                int triType = -1;
                Vertex u = (Vertex)iter.next();
                if (id.getIndex(u) <= i_v) continue;
                HashSet neighbors = new HashSet(CollectionUtils.union((Collection)u.getNeighbors(), (Collection)v.getNeighbors()));
                neighbors.remove(u);
                neighbors.remove(v);
                triType = u.isSuccessorOf(v) && v.isSuccessorOf(u) ? 3 : 2;
                int n = triType;
                count[n] = count[n] + (long)(g.numVertices() - neighbors.size() - 2);
                Iterator iterator = neighbors.iterator();
                while (iterator.hasNext()) {
                    Vertex w = (Vertex)iterator.next();
                    if (!TriadicCensus.shouldCount(id, u, v, w)) continue;
                    int n2 = TriadicCensus.triType(TriadicCensus.triCode(u, v, w));
                    count[n2] = count[n2] + 1L;
                }
            }
        }
        int sum = 0;
        for (int i = 2; i <= 16; ++i) {
            sum = (int)((long)sum + count[i]);
        }
        int n = g.numVertices();
        count[1] = n * (n - 1) * (n - 2) / 6 - sum;
        return count;
    }

    public static int triCode(Vertex u, Vertex v, Vertex w) {
        int i = 0;
        i += TriadicCensus.link(v, u) ? 1 : 0;
        i += TriadicCensus.link(u, v) ? 2 : 0;
        i += TriadicCensus.link(v, w) ? 4 : 0;
        i += TriadicCensus.link(w, v) ? 8 : 0;
        i += TriadicCensus.link(u, w) ? 16 : 0;
        return i += TriadicCensus.link(w, u) ? 32 : 0;
    }

    protected static boolean link(Vertex a, Vertex b) {
        return a.isPredecessorOf(b);
    }

    public static int triType(int triCode) {
        return codeToType[triCode];
    }

    protected static boolean shouldCount(Indexer id, Vertex u, Vertex v, Vertex w) {
        int i_w;
        int i_u = id.getIndex(u);
        if (i_u < (i_w = id.getIndex(w))) {
            return true;
        }
        int i_v = id.getIndex(v);
        return i_v < i_w && i_w < i_u && !v.isNeighborOf(w);
    }
}

