/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.BipartiteEdge;
import edu.uci.ics.jung.graph.impl.BipartiteVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;

public class BipartiteGraph
extends UndirectedSparseGraph {
    private Set aSet = new HashSet();
    private Set bSet = new HashSet();
    public static final Choice CLASSA = new Choice();
    public static final Choice CLASSB = new Choice();
    public static final Object BIPARTITE_USER_TAG = "BipartiteUserTag";

    public void initialize() {
        super.initialize();
        this.aSet = new HashSet();
        this.bSet = new HashSet();
    }

    public Set getAllVertices(Choice choice) {
        if (choice == CLASSA) {
            return Collections.unmodifiableSet(this.aSet);
        }
        if (choice == CLASSB) {
            return Collections.unmodifiableSet(this.bSet);
        }
        throw new IllegalArgumentException("Invalid partition specification " + choice);
    }

    public Choice getPartition(BipartiteVertex v) {
        if (this.aSet.contains(v)) {
            return CLASSA;
        }
        if (this.bSet.contains(v)) {
            return CLASSB;
        }
        if (v.getGraph() == this) {
            throw new IllegalArgumentException("Inconsistent state in graph!");
        }
        throw new IllegalArgumentException("Vertex " + v + " is not part of this graph");
    }

    public BipartiteVertex addVertex(BipartiteVertex v, Choice choice) {
        String exists = "Specified partition already contains vertex ";
        String dup = "Another partition already contains vertex ";
        if (choice == CLASSA) {
            if (this.aSet.contains(v)) {
                throw new IllegalArgumentException(exists + v);
            }
            if (this.bSet.contains(v)) {
                throw new IllegalArgumentException(dup + v);
            }
            this.aSet.add(v);
        } else if (choice == CLASSB) {
            if (this.bSet.contains(v)) {
                throw new IllegalArgumentException(exists + v);
            }
            if (this.aSet.contains(v)) {
                throw new IllegalArgumentException(dup + v);
            }
            this.bSet.add(v);
        } else {
            throw new IllegalArgumentException("Invalid partition specification for vertex " + v + ": " + choice);
        }
        super.addVertex(v);
        return v;
    }

    public BipartiteEdge addBipartiteEdge(BipartiteEdge bpe) {
        return (BipartiteEdge)super.addEdge(bpe);
    }

    public Edge addEdge(Edge ae) {
        throw new FatalException("Only add BipartiteEdges");
    }

    public Vertex addVertex(Vertex av) {
        throw new FatalException("Use addVertexX to add vertices to a BipartiteGraph ");
    }

    public static Graph fold(BipartiteGraph bpg, Choice vertexSet) {
        UndirectedSparseGraph newGraph = new UndirectedSparseGraph();
        Set vertices = bpg.getAllVertices(vertexSet);
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            BipartiteVertex v = (BipartiteVertex)iter.next();
            v.copy(newGraph);
        }
        HashSet<BipartiteVertex> coveredNodes = new HashSet<BipartiteVertex>();
        Iterator iter2 = vertices.iterator();
        while (iter2.hasNext()) {
            BipartiteVertex v = (BipartiteVertex)iter2.next();
            coveredNodes.add(v);
            Set hyperEdges = v.getNeighbors();
            MultiHashMap mm = new MultiHashMap();
            Iterator iterator = hyperEdges.iterator();
            while (iterator.hasNext()) {
                Vertex hyperEdge = (Vertex)iterator.next();
                BipartiteGraph.addAll((MultiMap)mm, hyperEdge.getNeighbors(), hyperEdge);
            }
            iterator = mm.keySet().iterator();
            while (iterator.hasNext()) {
                Vertex aVertex = (Vertex)iterator.next();
                if (coveredNodes.contains(aVertex)) continue;
                Edge newEdge = GraphUtils.addEdge(newGraph, (Vertex)v.getEqualVertex(newGraph), (Vertex)aVertex.getEqualVertex(newGraph));
                newEdge.addUserDatum(BIPARTITE_USER_TAG, mm.get((Object)aVertex), UserData.SHARED);
            }
        }
        return newGraph;
    }

    private static void addAll(MultiMap mm, Set keyset, Object value) {
        Iterator iter = keyset.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            mm.put(key, value);
        }
    }

    public void removeVertex(Vertex v) {
        super.removeVertex(v);
        if (this.aSet.contains(v)) {
            this.aSet.remove(v);
        } else {
            this.bSet.remove(v);
        }
    }

    public static final class Choice {
    }
}

