/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.random.generators.GraphGenerator;
import java.util.Random;

public class SimpleRandomGenerator
implements GraphGenerator {
    private int mNumVertices;
    private int mNumEdges;
    boolean seedSet = false;
    long seed = 0L;

    protected Vertex newVertex() {
        return new SparseVertex();
    }

    public SimpleRandomGenerator(int numVertices, int numEdges) {
        if (numVertices <= 0) {
            throw new IllegalArgumentException("A positive # of vertices must be specified.");
        }
        this.mNumVertices = numVertices;
        long calcVertices = numVertices;
        if (numEdges < 0 || (long)numEdges > calcVertices * (calcVertices - 1L) / 2L) {
            throw new IllegalArgumentException("# of edges [" + numEdges + "] must be between 0 and |V|(|V|-1)/2, v=" + numVertices);
        }
        this.mNumEdges = numEdges;
    }

    public void setSeed(long seed) {
        this.seedSet = true;
        this.seed = seed;
    }

    public ArchetypeGraph generateGraph() {
        Random rand = this.seedSet ? new Random(this.seed) : new Random();
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        for (int i = 0; i < this.mNumVertices; ++i) {
            g.addVertex(this.newVertex());
        }
        Indexer id = Indexer.getIndexer(g);
        int ctr = 0;
        while (ctr < this.mNumEdges) {
            Vertex v2;
            Vertex v1 = (Vertex)id.getVertex(rand.nextInt(this.mNumVertices));
            if (v1 == (v2 = (Vertex)id.getVertex(rand.nextInt(this.mNumVertices))) || v1.isNeighborOf(v2)) continue;
            g.addEdge(new UndirectedSparseEdge(v1, v2));
            ++ctr;
        }
        return g;
    }

    public long getNumEdges() {
        return this.mNumEdges;
    }

    public long getNumVertices() {
        return this.mNumVertices;
    }
}

