/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.ParallelEdgeIndexFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ParallelEdgeIndexSingleton
implements ParallelEdgeIndexFunction {
    private static ParallelEdgeIndexFunction instance;
    protected Map edge_index = new HashMap();

    private ParallelEdgeIndexSingleton() {
    }

    public static ParallelEdgeIndexFunction getInstance() {
        if (instance == null) {
            instance = new ParallelEdgeIndexSingleton();
        }
        return instance;
    }

    public int getIndex(Edge e) {
        Graph g = (Graph)e.getGraph();
        if (g == null) {
            throw new IllegalArgumentException("Orphaned edges may not be indexed.");
        }
        Integer index = (Integer)this.edge_index.get(new Pair(e, g));
        if (index == null) {
            index = this.getIndex_internal(e, g);
        }
        return index;
    }

    protected Integer getIndex_internal(Edge e, Graph g) {
        Pair endpoints = e.getEndpoints();
        Vertex u = (Vertex)endpoints.getFirst();
        Vertex v = (Vertex)endpoints.getSecond();
        Set commonEdgeSet = u.findEdgeSet(v);
        int count = 0;
        Iterator iterator = commonEdgeSet.iterator();
        while (iterator.hasNext()) {
            Edge other = (Edge)iterator.next();
            if (e.equals(other)) continue;
            this.edge_index.put(new Pair(other, g), new Integer(count));
            ++count;
        }
        Integer index = new Integer(count);
        this.edge_index.put(e, index);
        return index;
    }

    public void reset(Edge e) {
        Graph g = (Graph)e.getGraph();
        if (g == null) {
            throw new IllegalArgumentException("Orphaned edges may not be indexed.");
        }
        this.getIndex_internal(e, g);
    }

    public void reset() {
        this.edge_index.clear();
    }
}

