/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphZoomScrollPane
extends JPanel {
    protected VisualizationViewer vv;
    protected JScrollBar hsb;
    protected JScrollBar vsb;
    protected JComponent corner;
    protected boolean scrollBarsMayControlAdjusting = true;
    protected JPanel south;
    int count = 0;

    public GraphZoomScrollPane(VisualizationViewer vv) {
        super(new BorderLayout());
        this.vv = vv;
        this.addComponentListener(new ResizeListener());
        Dimension d = vv.getGraphLayout().getCurrentSize();
        this.vsb = new JScrollBar(1, 0, d.height, 0, d.height);
        this.hsb = new JScrollBar(0, 0, d.width, 0, d.width);
        this.vsb.addAdjustmentListener(new VerticalAdjustmentListenerImpl());
        this.hsb.addAdjustmentListener(new HorizontalAdjustmentListenerImpl());
        vv.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                VisualizationViewer vv = (VisualizationViewer)evt.getSource();
                GraphZoomScrollPane.this.setScrollBars(vv);
            }
        });
        this.add(vv);
        this.add((Component)this.vsb, "East");
        this.south = new JPanel(new BorderLayout());
        this.south.add(this.hsb);
        this.setCorner(new JPanel());
        this.add((Component)this.south, "South");
    }

    private void setScrollBars(VisualizationViewer vv) {
        Dimension d = vv.getGraphLayout().getCurrentSize();
        Point2D vvc = vv.inverseTransform(vv.getCenter());
        Point2D.Float lc = new Point2D.Float(d.width / 2, d.height / 2);
        float layoutScale = (float)vv.getLayoutTransformer().getScale();
        float viewScale = (float)vv.getViewTransformer().getScale();
        float scale = layoutScale * viewScale;
        float xmax = d.width;
        float ymax = d.height;
        float xext = xmax / scale;
        float yext = ymax / scale;
        float xval = (float)((double)((xmax - xext) / 2.0f) + vvc.getX() - ((Point2D)lc).getX());
        float yval = (float)((double)((ymax - yext) / 2.0f) + vvc.getY() - ((Point2D)lc).getY());
        float xmin = 0.0f;
        float ymin = 0.0f;
        this.scrollBarsMayControlAdjusting = false;
        this.hsb.setValues((int)xval, (int)xext, (int)xmin, (int)xmax);
        this.vsb.setValues((int)yval, (int)yext, (int)ymin, (int)ymax);
        this.scrollBarsMayControlAdjusting = true;
    }

    public JComponent getCorner() {
        return this.corner;
    }

    public void setCorner(JComponent corner) {
        this.corner = corner;
        corner.setPreferredSize(new Dimension(this.vsb.getPreferredSize().width, this.hsb.getPreferredSize().height));
        this.south.add((Component)this.corner, "East");
    }

    protected class ResizeListener
    extends ComponentAdapter {
        protected ResizeListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            GraphZoomScrollPane.this.setScrollBars(GraphZoomScrollPane.this.vv);
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    class VerticalAdjustmentListenerImpl
    implements AdjustmentListener {
        int previous = 0;

        VerticalAdjustmentListenerImpl() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            JScrollBar sb = (JScrollBar)e.getSource();
            BoundedRangeModel m = sb.getModel();
            int vval = m.getValue();
            float dv = this.previous - vval;
            this.previous = vval;
            if (dv != 0.0f && GraphZoomScrollPane.this.scrollBarsMayControlAdjusting) {
                AffineTransform at = AffineTransform.getTranslateInstance(0.0, dv);
                GraphZoomScrollPane.this.vv.getLayoutTransformer().concatenate(at);
            }
        }
    }

    class HorizontalAdjustmentListenerImpl
    implements AdjustmentListener {
        int previous = 0;

        HorizontalAdjustmentListenerImpl() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            int hval = e.getValue();
            float dh = this.previous - hval;
            this.previous = hval;
            if (dh != 0.0f && GraphZoomScrollPane.this.scrollBarsMayControlAdjusting) {
                AffineTransform at = AffineTransform.getTranslateInstance(dh, 0.0);
                GraphZoomScrollPane.this.vv.getLayoutTransformer().concatenate(at);
            }
        }
    }
}

