/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class CrossoverScalingGraphMousePlugin
extends ScalingGraphMousePlugin {
    protected double crossover = 1.0;
    protected ScalingControl scaler = new CrossoverScalingControl();

    public CrossoverScalingGraphMousePlugin() {
        this(1.1f, 0.9f);
    }

    public CrossoverScalingGraphMousePlugin(float in, float out) {
        super(0);
        this.in = in;
        this.out = out;
    }

    public void setCrossover(double crossover) {
        this.crossover = crossover;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            int amount = e.getWheelRotation();
            Point mouse = e.getPoint();
            Point2D center = vv.getCenter();
            if (this.zoomAtMouse) {
                if (amount > 0) {
                    this.scaler.scale(vv, this.in, mouse);
                } else if (amount < 0) {
                    this.scaler.scale(vv, this.out, mouse);
                }
            } else if (amount > 0) {
                this.scaler.scale(vv, this.in, center);
            } else if (amount < 0) {
                this.scaler.scale(vv, this.out, center);
            }
            e.consume();
            vv.repaint();
        }
    }
}

