/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.graphdraw;

import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgeColorFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.EdgeThicknessFunction;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.decorators.VertexColorFunction;
import edu.uci.ics.jung.graph.predicates.EdgePredicate;
import edu.uci.ics.jung.graph.predicates.SelfLoopEdgePredicate;
import edu.uci.ics.jung.visualization.AbstractRenderer;
import edu.uci.ics.jung.visualization.contrib.Arrow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class SettableRenderer
extends AbstractRenderer {
    protected Color vertexFGColor = Color.BLACK;
    protected Color vertexPickedColor = Color.ORANGE;
    protected Color vertexBGColor = Color.RED;
    protected VertexColorFunction vertexColorFunction;
    protected EdgeThicknessFunction edgeThicknessFunction;
    protected int edgeThickness;
    protected Color edgeColor = Color.BLACK;
    protected EdgeColorFunction edgeColorFunction;
    protected StringLabeller mStringLabeller;
    protected boolean mShouldDrawSelfLoops = false;
    protected boolean mDrawLightBoxes = true;
    protected boolean mShouldDrawArrowsUndirected = false;
    protected boolean mShouldDrawArrowsDirected = true;
    protected Arrow mArrow;
    protected EdgeStringer mEdgeLabelFunction;
    protected int mLineHeight;
    protected static EdgePredicate self_loop = SelfLoopEdgePredicate.getInstance();

    public SettableRenderer() {
        this.mStringLabeller = null;
    }

    public SettableRenderer(StringLabeller sl) {
        this.mStringLabeller = sl;
    }

    public SettableRenderer(StringLabeller sl, EdgeStringer el) {
        this.mStringLabeller = sl;
        this.mEdgeLabelFunction = el;
    }

    public void setLightDrawing(boolean b) {
        this.mDrawLightBoxes = b;
    }

    public void setStringLabeller(StringLabeller sl) {
        this.mStringLabeller = sl;
    }

    public void setEdgeColor(Color c) {
        this.edgeColor = c;
    }

    public void setEdgeColorFunction(EdgeColorFunction ecf) {
        this.edgeColorFunction = ecf;
    }

    public void setEdgeThickness(int i) {
        this.edgeThicknessFunction = null;
        this.edgeThickness = i;
    }

    public void setEdgeThicknessFunction(EdgeThicknessFunction etf) {
        this.edgeThicknessFunction = etf;
        this.edgeThickness = 0;
    }

    public void setShouldDrawDirectedArrows(boolean b) {
        this.mShouldDrawArrowsDirected = b;
    }

    public void setShouldDrawUndirectedArrows(boolean b) {
        this.mShouldDrawArrowsUndirected = b;
    }

    public void setShouldDrawSelfLoops(boolean b) {
        this.mShouldDrawSelfLoops = b;
    }

    public void paintEdge(Graphics g, Edge e, int x1, int y1, int x2, int y2) {
        String label;
        Graphics2D g2d = (Graphics2D)g;
        this.mLineHeight = g2d.getFontMetrics().getHeight();
        float edgeWidth = this.edgeThicknessFunction != null ? this.edgeThicknessFunction.getEdgeThickness(e) : (float)this.edgeThickness;
        if (this.edgeColorFunction == null) {
            g.setColor(this.edgeColor);
        } else {
            g.setColor(this.edgeColorFunction.getEdgeColor(e));
        }
        if (edgeWidth == 1.0f) {
            this.drawEdgeSimple(g, e, x1, y1, x2, y2);
        } else {
            this.drawEdge(edgeWidth, g, e, x1, y1, x2, y2);
        }
        if (this.mShouldDrawArrowsDirected && e instanceof DirectedEdge) {
            this.drawArrowhead(g2d, e, x1, y1, x2, y2);
        }
        if (this.mShouldDrawArrowsUndirected && e instanceof UndirectedEdge) {
            this.drawArrowhead(g2d, e, x1, y1, x2, y2);
            this.drawArrowhead(g2d, e, x2, y2, x1, y1);
        }
        String string = label = this.mEdgeLabelFunction == null ? null : this.mEdgeLabelFunction.getLabel(e);
        if (label != null) {
            this.labelEdge(g2d, e, label, x1, x2, y1, y2);
        }
    }

    public void labelEdge(Graphics2D g2d, Edge e, String label, int x1, int x2, int y1, int y2) {
        if (self_loop.evaluate(e)) {
            g2d.drawString(label, x1 - 3, y1 - 10 - this.mLineHeight / 2);
            return;
        }
        int distX = x2 - x1;
        int distY = y2 - y1;
        double totalLength = Math.sqrt(distX * distX + distY * distY);
        double closeness = e instanceof DirectedEdge ? 0.73 : 0.5;
        int posX = (int)((double)x1 + closeness * (double)distX);
        int posY = (int)((double)y1 + closeness * (double)distY);
        int LEN = 10;
        int xDisplacement = (int)((double)LEN * ((double)(-distY) / totalLength));
        int yDisplacement = (int)((double)LEN * ((double)distX / totalLength));
        g2d.drawString(label, posX + xDisplacement, posY + yDisplacement + this.mLineHeight / 2);
    }

    protected void drawArrowhead(Graphics2D g2d, Edge e, int xsource, int ysource, int xdest, int ydest) {
        if (this.mArrow == null) {
            this.mArrow = new Arrow("Arrow.CLASSIC", 7, 9);
        }
        if (this.mShouldDrawSelfLoops && self_loop.evaluate(e)) {
            this.mArrow.drawArrow(g2d, xsource - 10, ysource - 5, xsource, ysource, 15);
            return;
        }
        if (this.mDrawLightBoxes) {
            this.mArrow.drawArrow(g2d, xsource, ysource, xdest, ydest, 12);
        } else {
            this.mArrow.drawArrow(g2d, xsource, ysource, xdest, ydest, 16);
        }
    }

    protected void drawEdge(float edgeWidth, Graphics g, Edge e, int x1, int y1, int x2, int y2) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke previous = g2d.getStroke();
        g2d.setStroke(new BasicStroke(edgeWidth));
        this.drawEdgeSimple(g, e, x1, y1, x2, y2);
        g2d.setStroke(previous);
    }

    protected void drawEdgeSimple(Graphics g, Edge e, int x1, int y1, int x2, int y2) {
        if (this.mShouldDrawSelfLoops && self_loop.evaluate(e)) {
            g.drawOval(x1 - 15, y1 - 30, 30, 30);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public void setVertexForegroundColor(Color vertexColor) {
        this.vertexFGColor = vertexColor;
    }

    public void setVertexPickedColor(Color vertexColor) {
        this.vertexPickedColor = vertexColor;
    }

    public void setVertexBGColor(Color vertexColor) {
        this.vertexBGColor = vertexColor;
    }

    public void setVertexColorFunction(VertexColorFunction vcf) {
        this.vertexColorFunction = vcf;
    }

    protected String getLabel(Vertex v) {
        if (this.mStringLabeller == null) {
            return "";
        }
        String s = this.mStringLabeller.getLabel(v);
        if (s == null) {
            return "?";
        }
        return s;
    }

    public void paintVertex(Graphics g, Vertex v, int x, int y) {
        Color fg;
        String label = this.getLabel(v);
        if (this.mDrawLightBoxes) {
            this.paintLightVertex(g, v, x, y, label);
            return;
        }
        Color color = fg = this.vertexColorFunction == null ? this.vertexFGColor : this.vertexColorFunction.getForeColor(v);
        if (this.vertexColorFunction == null) {
            if (this.isPicked(v)) {
                g.setColor(this.vertexPickedColor);
            } else {
                g.setColor(this.vertexBGColor);
            }
        } else {
            g.setColor(this.vertexColorFunction.getBackColor(v));
        }
        g.fillRect(x - 8, y - 6, g.getFontMetrics().stringWidth(label) + 8, 16);
        g.setColor(fg);
        g.drawString(label, x - 4, y + 6);
    }

    protected void paintLightVertex(Graphics g, Vertex v, int x, int y, String label) {
        Color bg = this.vertexColorFunction == null ? (this.isPicked(v) ? this.vertexPickedColor : this.vertexBGColor) : this.vertexColorFunction.getBackColor(v);
        Color fg = this.vertexColorFunction == null ? this.vertexFGColor : this.vertexColorFunction.getForeColor(v);
        g.setColor(fg);
        g.fillRect(x - 7, y - 7, 14, 14);
        g.setColor(bg);
        g.fillRect(x - 6, y - 6, 12, 12);
        if (label.equals("?")) {
            return;
        }
        g.setColor(fg);
        g.drawString(label, x + 8, y + 6);
    }
}

