/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.AbstractHyperbolicLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Dimension;

public class HyperbolicLayoutLensSupport
extends AbstractHyperbolicLensSupport
implements HyperbolicLensSupport {
    MutableTransformer savedViewTransformer;

    public HyperbolicLayoutLensSupport(VisualizationViewer vv) {
        super(vv);
        this.hyperbolicTransformer = new HyperbolicTransformer(vv, vv.getLayoutTransformer());
        Dimension d = vv.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = vv.getPreferredSize();
        }
        this.hyperbolicTransformer.setViewRadius(d.width / 5);
    }

    public void activate() {
        this.lens = new AbstractHyperbolicLensSupport.Lens(this.hyperbolicTransformer);
        this.vv.setLayoutTransformer(this.hyperbolicTransformer);
        this.vv.setViewTransformer(new MutableAffineTransformer());
        this.vv.addPreRenderPaintable(this.lens);
        this.vv.setGraphMouse(this.hyperbolicGraphMouse);
        this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>");
        this.vv.repaint();
    }

    public void deactivate() {
        if (this.savedViewTransformer != null) {
            this.vv.setViewTransformer(this.savedViewTransformer);
        }
        if (this.hyperbolicTransformer != null) {
            this.vv.removePreRenderPaintable(this.lens);
            this.vv.setLayoutTransformer(this.hyperbolicTransformer.getDelegate());
        }
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.repaint();
    }
}

