/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class AspectSourceFlags
extends CGMTag {
    public static final int LINE_TYPE = 0;
    public static final int LINE_WIDTH = 1;
    public static final int LINE_COLOR = 2;
    public static final int MARKER_TYPE = 3;
    public static final int MARKER_SIZE = 4;
    public static final int MARKER_COLOR = 5;
    public static final int TEXT_FONT_INDEX = 6;
    public static final int TEXT_PRECISION = 7;
    public static final int CHARACTER_EXPANSION_FACTOR = 8;
    public static final int CHARACTER_SPACING = 9;
    public static final int TEXT_COLOR = 10;
    public static final int INTERIOR_STYLE = 11;
    public static final int FILL_COLOR = 12;
    public static final int HATCH_INDEX = 13;
    public static final int PATTERN_INDEX = 14;
    public static final int EDGE_TYPE = 15;
    public static final int EDGE_WIDTH = 16;
    public static final int EDGE_COLOR = 17;
    public static final int INDIVIDUAL = 0;
    public static final int BUNDLED = 1;
    private int[] asfType;
    private int[] asfValue;

    public AspectSourceFlags() {
        super(5, 35, 1);
    }

    public AspectSourceFlags(int[] asfType, int[] asfValue) {
        this();
        this.asfType = asfType;
        this.asfValue = asfValue;
    }

    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        int i = 0;
        while (i < this.asfType.length) {
            cgm.writeEnumerate(this.asfType[i]);
            cgm.writeEnumerate(this.asfValue[i]);
            ++i;
        }
    }

    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.println("ASF");
        cgm.indent();
        int i = 0;
        while (i < this.asfType.length) {
            switch (this.asfType[i]) {
                default: {
                    cgm.print("LINETYPE");
                    break;
                }
                case 1: {
                    cgm.print("LINEWIDTH");
                    break;
                }
                case 2: {
                    cgm.print("LINECOLR");
                    break;
                }
                case 3: {
                    cgm.print("MARKERTYPE");
                    break;
                }
                case 4: {
                    cgm.print("MARKERSIZE");
                    break;
                }
                case 5: {
                    cgm.print("MARKERCOLR");
                    break;
                }
                case 6: {
                    cgm.print("TEXTFONTINDEX");
                    break;
                }
                case 7: {
                    cgm.print("TEXTPREC");
                    break;
                }
                case 8: {
                    cgm.print("CHAREXPAN");
                    break;
                }
                case 9: {
                    cgm.print("CHARSPACE");
                    break;
                }
                case 10: {
                    cgm.print("TEXTCOLR");
                    break;
                }
                case 11: {
                    cgm.print("INTSTYLE");
                    break;
                }
                case 12: {
                    cgm.print("FILLCOLR");
                    break;
                }
                case 13: {
                    cgm.print("HATCHINDEX");
                    break;
                }
                case 14: {
                    cgm.print("PATINDEX");
                    break;
                }
                case 15: {
                    cgm.print("EDGETYPE");
                    break;
                }
                case 16: {
                    cgm.print("EDGEWIDTH");
                    break;
                }
                case 17: {
                    cgm.print("EDGECOLR");
                }
            }
            cgm.print(", ");
            switch (this.asfValue[i]) {
                default: {
                    cgm.print("INDIV");
                    break;
                }
                case 1: {
                    cgm.print("BUNDLED");
                }
            }
            cgm.println();
            ++i;
        }
        cgm.outdent();
    }
}

