/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.PolylinePathConstructor;
import org.freehep.graphicsio.cgm.EdgeVisibility;
import org.freehep.graphicsio.cgm.InteriorStyle;
import org.freehep.graphicsio.cgm.Polygon;
import org.freehep.graphicsio.cgm.Polyline;
import org.freehep.util.io.TaggedOutput;

public class CGMPathConstructor
extends PolylinePathConstructor {
    private TaggedOutput os;
    private AffineTransform matrix;

    public CGMPathConstructor(TaggedOutput os, boolean fill, AffineTransform matrix) {
        super(fill);
        this.os = os;
        this.matrix = matrix;
    }

    protected void writePolyline(Vector polyline) throws IOException {
        int n = polyline.size();
        Object[] src = new Point2D[n];
        polyline.copyInto(src);
        Point2D[] dst = new Point2D[n];
        this.matrix.transform((Point2D[])src, 0, dst, 0, n);
        if (this.fill) {
            this.os.writeTag(new Polygon(dst));
        } else if (this.closed) {
            this.os.writeTag(new EdgeVisibility(true));
            this.os.writeTag(new InteriorStyle(0));
            this.os.writeTag(new Polygon(dst));
            this.os.writeTag(new InteriorStyle(1));
            this.os.writeTag(new EdgeVisibility(false));
        } else {
            this.os.writeTag(new Polyline(dst));
        }
    }
}

