/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class PolygonSet
extends CGMTag {
    public static final int INVISIBLE = 0;
    public static final int VISIBLE = 1;
    public static final int CLOSE_INVISIBLE = 2;
    public static final int CLOSE_VISIBLE = 3;
    private Point2D[] p;
    private int[] flags;

    public PolygonSet() {
        super(4, 8, 1);
    }

    public PolygonSet(Point2D[] p, int[] flags) {
        this();
        this.p = p;
        this.flags = flags;
    }

    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        int i = 0;
        while (i < this.p.length) {
            cgm.writePoint(this.p[i]);
            cgm.writeEnumerate(this.flags[i]);
            ++i;
        }
    }

    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.println("POLYGONSET");
        int i = 0;
        while (i < this.p.length) {
            cgm.writePoint(this.p[i]);
            cgm.print(", ");
            switch (this.flags[i]) {
                default: {
                    cgm.print("INVIS");
                    break;
                }
                case 1: {
                    cgm.print("VIS");
                    break;
                }
                case 2: {
                    cgm.print("CLOSEINVIS");
                    break;
                }
                case 3: {
                    cgm.print("CLOSEVIS");
                }
            }
            cgm.println();
            ++i;
        }
    }
}

