/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class GDIComment
extends EMFTag {
    private String comment;

    GDIComment() {
        super(70, 1);
    }

    public GDIComment(String comment) {
        this();
        this.comment = comment;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int l = emf.readDWORD();
        GDIComment tag = new GDIComment(new String(emf.readBYTE(l)));
        if (l % 4 != 0) {
            emf.readBYTE(4 - l % 4);
        }
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        byte[] b = this.comment.getBytes();
        emf.writeDWORD(b.length);
        emf.writeBYTE(b);
        if (b.length % 4 != 0) {
            int i = 0;
            while (i < 4 - b.length % 4) {
                emf.writeBYTE(0);
                ++i;
            }
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  length: " + this.comment.length();
    }
}

