/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.Gradient;
import org.freehep.graphicsio.emf.GradientRectangle;
import org.freehep.graphicsio.emf.GradientTriangle;
import org.freehep.graphicsio.emf.TriVertex;

public class GradientFill
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private int mode;
    private TriVertex[] vertices;
    private Gradient[] gradients;

    GradientFill() {
        super(118, 1);
    }

    public GradientFill(Rectangle bounds, int mode, TriVertex[] vertices, Gradient[] gradients) {
        this();
        this.bounds = bounds;
        this.mode = mode;
        this.vertices = vertices;
        this.gradients = gradients;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle bounds = emf.readRECTL();
        TriVertex[] vertices = new TriVertex[emf.readDWORD()];
        Gradient[] gradients = new Gradient[emf.readDWORD()];
        int mode = emf.readULONG();
        int i = 0;
        while (i < vertices.length) {
            vertices[i] = new TriVertex(emf);
            ++i;
        }
        int i2 = 0;
        while (i2 < gradients.length) {
            gradients[i2] = mode == 2 ? new GradientTriangle(emf) : new GradientRectangle(emf);
            ++i2;
        }
        GradientFill tag = new GradientFill(bounds, mode, vertices, gradients);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.vertices.length);
        emf.writeDWORD(this.gradients.length);
        emf.writeULONG(this.mode);
        int i = 0;
        while (i < this.vertices.length) {
            this.vertices[i].write(emf);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.gradients.length) {
            this.gradients[i2].write(emf);
            ++i2;
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  bounds: " + this.bounds + "\n");
        s.append("  mode: " + this.mode + "\n");
        int i = 0;
        while (i < this.vertices.length) {
            s.append("  vertex[" + i + "]: " + this.vertices[i] + "\n");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.gradients.length) {
            s.append("  gradient[" + i2 + "]: " + this.gradients[i2] + "\n");
            ++i2;
        }
        return s.toString();
    }
}

