/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyPolygon16
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPolys;
    private int[] numberOfPoints;
    private Point[][] points;

    PolyPolygon16() {
        super(91, 1);
    }

    public PolyPolygon16(Rectangle bounds, int numberOfPolys, int[] numberOfPoints, Point[][] points) {
        this();
        this.bounds = bounds;
        this.numberOfPolys = numberOfPolys;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        int totalNumberOfPoints = emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        int i = 0;
        while (i < np) {
            pc[i] = emf.readDWORD();
            points[i] = new Point[pc[i]];
            ++i;
        }
        int i2 = 0;
        while (i2 < np) {
            points[i2] = emf.readPOINTS(pc[i2]);
            ++i2;
        }
        PolyPolygon16 tag = new PolyPolygon16(bounds, np, pc, points);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.numberOfPolys);
        int c = 0;
        int i = 0;
        while (i < this.numberOfPolys) {
            c += this.numberOfPoints[i];
            ++i;
        }
        emf.writeDWORD(c);
        int i2 = 0;
        while (i2 < this.numberOfPolys) {
            emf.writeDWORD(this.numberOfPoints[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numberOfPolys) {
            emf.writePOINTS(this.numberOfPoints[i3], this.points[i3]);
            ++i3;
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #polys: " + this.numberOfPolys;
    }
}

