/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyPolyline
extends EMFTag {
    private Rectangle bounds;
    private int start;
    private int end;
    private int[] numberOfPoints;
    private Point[][] points;

    PolyPolyline() {
        super(7, 1);
    }

    public PolyPolyline(Rectangle bounds, int start, int end, int[] numberOfPoints, Point[][] points) {
        this();
        this.bounds = bounds;
        this.start = start;
        this.end = Math.min(end, numberOfPoints.length - 1);
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        int totalNumberOfPoints = emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        int i = 0;
        while (i < np) {
            pc[i] = emf.readDWORD();
            points[i] = new Point[pc[i]];
            ++i;
        }
        int i2 = 0;
        while (i2 < np) {
            points[i2] = emf.readPOINTL(pc[i2]);
            ++i2;
        }
        PolyPolyline tag = new PolyPolyline(bounds, 0, np - 1, pc, points);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.end - this.start + 1);
        int c = 0;
        int i = this.start;
        while (i < this.end + 1) {
            c += this.numberOfPoints[i];
            ++i;
        }
        emf.writeDWORD(c);
        int i2 = this.start;
        while (i2 < this.end + 1) {
            emf.writeDWORD(this.numberOfPoints[i2]);
            ++i2;
        }
        int i3 = this.start;
        while (i3 < this.end + 1) {
            emf.writePOINTL(this.numberOfPoints[i3], this.points[i3]);
            ++i3;
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #polys: " + (this.end - this.start);
    }
}

