/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class Region {
    private Rectangle bounds;
    private Rectangle region;

    public Region(Rectangle bounds, Rectangle region) {
        this.bounds = bounds;
        this.region = region;
    }

    Region(EMFInputStream emf) throws IOException {
        int length = emf.readDWORD();
        int mode = emf.readDWORD();
        int nRect = emf.readDWORD();
        int size = emf.readDWORD();
        this.bounds = emf.readRECTL();
        this.region = emf.readRECTL();
        int i = 16;
        while (i < size) {
            emf.readRECTL();
            i += 16;
        }
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writeDWORD(32);
        emf.writeDWORD(1);
        emf.writeDWORD(1);
        emf.writeDWORD(16);
        emf.writeRECTL(this.bounds);
        emf.writeRECTL(this.region);
    }

    public int length() {
        return 48;
    }

    public String toString() {
        return "  Region\n    bounds: " + this.bounds + "\n" + "    region: " + this.region;
    }
}

