/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class Text
implements EMFConstants {
    private Point pos;
    private String string;
    private int options;
    private int[] widths;
    private Rectangle bounds;

    public Text(Point pos, String string, int options, Rectangle bounds, int[] widths) {
        this.pos = pos;
        this.string = string;
        this.options = options;
        this.bounds = bounds;
        this.widths = widths;
    }

    Text(EMFInputStream emf) throws IOException {
        this.pos = emf.readPOINTL();
        int sLen = emf.readDWORD();
        int sOffset = emf.readDWORD();
        this.options = emf.readDWORD();
        this.bounds = emf.readRECTL();
        int cOffset = emf.readDWORD();
        this.string = new String(emf.readBYTE(sLen));
        if (sLen % 4 != 0) {
            int i = 0;
            while (i < 4 - sLen % 4) {
                emf.readBYTE();
                ++i;
            }
        }
        this.widths = new int[sLen];
        int i = 0;
        while (i < sLen) {
            this.widths[i] = emf.readDWORD();
            ++i;
        }
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writePOINTL(this.pos);
        emf.writeDWORD(this.string.length());
        emf.writeDWORD(76);
        emf.writeDWORD(this.options);
        emf.writeRECTL(this.bounds);
        int pad = this.string.length() % 4;
        if (pad > 0) {
            pad = 4 - pad;
        }
        emf.writeDWORD(76 + this.string.length() + pad);
        emf.writeBYTE(this.string.getBytes());
        int i = 0;
        while (i < pad) {
            emf.writeBYTE(0);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.string.length()) {
            emf.writeDWORD(this.widths[i2]);
            ++i2;
        }
    }

    public String toString() {
        StringBuffer widthsS = new StringBuffer();
        int i = 0;
        while (i < this.string.length()) {
            widthsS.append("," + this.widths[i]);
            ++i;
        }
        widthsS.append(']');
        widthsS.setCharAt(0, '[');
        return "  Text\n    pos: " + this.pos + "\n" + "    options: " + this.options + "\n" + "    bounds: " + this.bounds + "\n" + "    string: " + this.string + "\n" + "    widths: " + widthsS;
    }
}

