/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import org.freehep.graphics2d.ScreenConstants;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class ImageSizePanel
extends OptionPanel {
    private static final String[] imageSizeList = new String[]{"ImageSize", "Custom", "600x480", "800x600", "1024x768", "1280x1024", "1400x1050", "1600x1200"};
    private String key;
    private Dimension initialDimension;
    private JComboBox imageSizeCombo;
    private JFormattedTextField imageWidth;
    private JFormattedTextField imageHeight;

    public ImageSizePanel(Properties user, String rootKey) {
        super("Image Size");
        this.key = rootKey + "." + "ImageSize";
        UserProperties options = new UserProperties(user);
        this.initialDimension = options.getPropertyDimension(this.key);
        this.imageSizeCombo = new JComboBox<String>(imageSizeList);
        this.add("0 * [5 15 5 15] r", new JLabel("Preset Sizes"));
        this.add("1 * [5 15 5 15] lw", this.imageSizeCombo);
        this.add("0 * [5 15 5 15] r", new JLabel("Width"));
        this.imageWidth = new JFormattedTextField(new TextFieldFormatter());
        this.imageWidth.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.imageWidth);
        this.add("0 * [5 15 5 15] r", new JLabel("Height"));
        this.imageHeight = new JFormattedTextField(new TextFieldFormatter());
        this.imageHeight.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.imageHeight);
        this.imageSizeCombo.addItemListener(new ComboListener());
        this.imageWidth.addActionListener(new TextFieldListener());
        this.imageHeight.addActionListener(new TextFieldListener());
        this.imageWidth.setValue(new Integer(this.initialDimension.width));
        this.imageHeight.setValue(new Integer(this.initialDimension.height));
        new TextFieldListener().actionPerformed(null);
        new ComboListener().itemStateChanged(null);
    }

    public boolean applyChangedOptions(Properties options) {
        boolean changed = false;
        Dimension size = new Dimension(((Number)this.imageWidth.getValue()).intValue(), ((Number)this.imageHeight.getValue()).intValue());
        if (!size.equals(this.initialDimension)) {
            options.setProperty(this.key, size.width + ", " + size.height);
            changed = true;
        }
        return changed;
    }

    private class TextFieldFormatter
    extends JFormattedTextField.AbstractFormatter {
        JFormattedTextField field;

        private TextFieldFormatter() {
        }

        public void install(JFormattedTextField field) {
            super.install(field);
            this.field = field;
        }

        public void uninstall() {
            this.field = null;
        }

        public Object stringToValue(String text) throws ParseException {
            try {
                Integer value = new Integer(text);
                if (value < 0) {
                    throw new NumberFormatException();
                }
                return value;
            }
            catch (NumberFormatException nfe) {
                Object value = this.field.getValue();
                this.field.setValue(value);
                return value;
            }
        }

        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return "0";
            }
            return value.toString();
        }
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent event) {
            int width = ((Number)ImageSizePanel.this.imageWidth.getValue()).intValue();
            int height = ((Number)ImageSizePanel.this.imageHeight.getValue()).intValue();
            if (width == 0 && height == 0) {
                ImageSizePanel.this.imageSizeCombo.setSelectedIndex(0);
                return;
            }
            int i = 2;
            while (i < imageSizeList.length) {
                Dimension d = ScreenConstants.getSize(imageSizeList[i]);
                if (width == d.width && height == d.height) {
                    ImageSizePanel.this.imageSizeCombo.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
            ImageSizePanel.this.imageSizeCombo.setSelectedIndex(1);
        }
    }

    private class ComboListener
    implements ItemListener {
        private ComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            int index = ImageSizePanel.this.imageSizeCombo.getSelectedIndex();
            switch (index) {
                case 0: {
                    ImageSizePanel.this.imageWidth.setEnabled(false);
                    ImageSizePanel.this.imageHeight.setEnabled(false);
                    ImageSizePanel.this.imageWidth.setValue(new Integer(0));
                    ImageSizePanel.this.imageHeight.setValue(new Integer(0));
                    break;
                }
                case 1: {
                    ImageSizePanel.this.imageWidth.setEnabled(true);
                    ImageSizePanel.this.imageHeight.setEnabled(true);
                    break;
                }
                default: {
                    ImageSizePanel.this.imageWidth.setEnabled(true);
                    ImageSizePanel.this.imageHeight.setEnabled(true);
                    Dimension d = ScreenConstants.getSize(imageSizeList[index]);
                    ImageSizePanel.this.imageWidth.setValue(new Integer(d.width));
                    ImageSizePanel.this.imageHeight.setValue(new Integer(d.height));
                }
            }
        }
    }
}

