/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class PageMarginPanel
extends OptionPanel {
    private static final String[] pageMarginList = new String[]{"Custom", "Small", "Medium", "Large"};
    private String key;
    private Insets initialMargins;
    private JComboBox pageMarginCombo;
    private JFormattedTextField top;
    private JFormattedTextField left;
    private JFormattedTextField bottom;
    private JFormattedTextField right;

    public PageMarginPanel(Properties user, String rootKey) {
        super("Page Margins");
        this.key = rootKey + "." + "PageMargins";
        UserProperties options = new UserProperties(user);
        this.initialMargins = options.getPropertyInsets(this.key);
        this.pageMarginCombo = new JComboBox<String>(pageMarginList);
        this.add("0 * [5 15 5 15] r", new JLabel("Preset Margins"));
        this.add("1 * [5 15 5 15] lw", this.pageMarginCombo);
        this.add("0 * [5 15 5 15] r", new JLabel("Top"));
        this.top = new JFormattedTextField(new TextFieldFormatter());
        this.top.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.top);
        this.add("0 * [5 15 5 15] r", new JLabel("Bottom"));
        this.bottom = new JFormattedTextField(new TextFieldFormatter());
        this.bottom.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.bottom);
        this.add("0 * [5 15 5 15] r", new JLabel("Left"));
        this.left = new JFormattedTextField(new TextFieldFormatter());
        this.left.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.left);
        this.add("0 * [5 15 5 15] r", new JLabel("Right"));
        this.right = new JFormattedTextField(new TextFieldFormatter());
        this.right.setColumns(10);
        this.add("1 * [5 15 5 15] lw", this.right);
        this.pageMarginCombo.addItemListener(new ComboListener());
        this.top.addActionListener(new TextFieldListener());
        this.bottom.addActionListener(new TextFieldListener());
        this.left.addActionListener(new TextFieldListener());
        this.right.addActionListener(new TextFieldListener());
        this.top.setValue(new Integer(this.initialMargins.top));
        this.bottom.setValue(new Integer(this.initialMargins.bottom));
        this.left.setValue(new Integer(this.initialMargins.left));
        this.right.setValue(new Integer(this.initialMargins.right));
        new TextFieldListener().actionPerformed(null);
        new ComboListener().itemStateChanged(null);
    }

    public boolean applyChangedOptions(Properties options) {
        boolean changed = false;
        Insets margins = new Insets(((Number)this.top.getValue()).intValue(), ((Number)this.left.getValue()).intValue(), ((Number)this.bottom.getValue()).intValue(), ((Number)this.right.getValue()).intValue());
        if (!margins.equals(this.initialMargins)) {
            UserProperties.setProperty(options, this.key, margins);
            changed = true;
        }
        return changed;
    }

    private class TextFieldFormatter
    extends JFormattedTextField.AbstractFormatter {
        JFormattedTextField field;

        private TextFieldFormatter() {
        }

        public void install(JFormattedTextField field) {
            super.install(field);
            this.field = field;
        }

        public void uninstall() {
            this.field = null;
        }

        public Object stringToValue(String text) throws ParseException {
            try {
                Integer value = new Integer(text);
                return value;
            }
            catch (NumberFormatException nfe) {
                Object value = this.field.getValue();
                this.field.setValue(value);
                return value;
            }
        }

        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return "0";
            }
            return value.toString();
        }
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Insets margins = new Insets(((Number)PageMarginPanel.this.top.getValue()).intValue(), ((Number)PageMarginPanel.this.left.getValue()).intValue(), ((Number)PageMarginPanel.this.bottom.getValue()).intValue(), ((Number)PageMarginPanel.this.right.getValue()).intValue());
            int i = 1;
            while (i < pageMarginList.length) {
                Insets insets = PageConstants.getMargins(pageMarginList[i]);
                if (margins.equals(insets)) {
                    PageMarginPanel.this.pageMarginCombo.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
            PageMarginPanel.this.pageMarginCombo.setSelectedIndex(0);
        }
    }

    private class ComboListener
    implements ItemListener {
        private ComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            int index = PageMarginPanel.this.pageMarginCombo.getSelectedIndex();
            if (index != 0) {
                Insets insets = PageConstants.getMargins(pageMarginList[index]);
                PageMarginPanel.this.top.setValue(new Integer(insets.top));
                PageMarginPanel.this.bottom.setValue(new Integer(insets.bottom));
                PageMarginPanel.this.left.setValue(new Integer(insets.left));
                PageMarginPanel.this.right.setValue(new Integer(insets.right));
            }
        }
    }
}

