/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFTable;

public class TTFNameTable
extends TTFTable {
    private int format;
    private int numberOfNameRecords;
    private int stringStorage;
    private String[][] name = new String[4][19];

    public String getTag() {
        return "name";
    }

    public void readTable() throws IOException {
        this.format = this.ttf.readUShort();
        this.numberOfNameRecords = this.ttf.readUShort();
        this.stringStorage = this.ttf.readUShort();
        int i = 0;
        while (i < this.numberOfNameRecords) {
            int pid = this.ttf.readUShort();
            int eid = this.ttf.readUShort();
            int lid = this.ttf.readUShort();
            int nid = this.ttf.readUShort();
            int stringLen = this.ttf.readUShort();
            int stringOffset = this.ttf.readUShort();
            this.ttf.pushPos();
            this.ttf.seek(this.stringStorage + stringOffset);
            byte[] b = new byte[stringLen];
            this.ttf.readFully(b);
            if (pid == 0) {
                this.name[pid][nid] = new String(b, "UnicodeBig");
            } else if (pid == 1 && eid == 0) {
                if (lid == 0) {
                    this.name[pid][nid] = new String(b, "ISO8859-1");
                }
            } else if (pid == 3 && eid == 1) {
                if (lid == 1033) {
                    this.name[pid][nid] = new String(b, "UnicodeBig");
                }
            } else {
                System.out.println("Unimplemented PID, EID, LID scheme: " + pid + ", " + eid + ", " + lid);
                System.out.println("NID = " + nid);
                this.name[pid][nid] = new String(b, "Default");
            }
            this.ttf.popPos();
            ++i;
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  format: " + this.format);
        int i = 0;
        while (i < this.name.length) {
            int j = 0;
            while (j < this.name[i].length) {
                if (this.name[i][j] != null) {
                    s.append("\n  name[" + i + "][" + j + "]: " + this.name[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return s.toString();
    }
}

