/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.java;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.png.PNGEncoder;
import org.freehep.util.UserProperties;
import org.freehep.util.Value;
import org.freehep.util.io.IndentPrintWriter;
import org.freehep.util.io.LineNumberWriter;

public class JAVAGraphics2D
extends VectorGraphics
implements LineNumberWriter.LineNumberListener {
    private static final int MAX_LINES_PER_METHOD = 200;
    private Map vg = new HashMap();
    private Value vgIndex = new Value().set(0);
    private Value paintSequenceNo = new Value().set(0);
    private Value blockLevel = new Value().set(0);
    private UserProperties properties;
    private int width = 800;
    private int height = 600;
    private String className = "TemporaryName";
    private LineNumberWriter lineWriter;
    private IndentPrintWriter out;
    private Color backgroundColor;
    private Color color = Color.WHITE;
    private Paint paint = Color.BLACK;
    private String creator = "FreeHEP JAVAGraphics2D";
    private int colorMode = 0;
    private Stroke stroke = new BasicStroke();
    private AffineTransform transform = new AffineTransform();
    private RenderingHints hints = new RenderingHints(null);
    private boolean isDeviceIndependent;
    private Composite composite;
    private Shape clip;
    private Font font = new Font("Serif", 0, 12);
    private static final String rootKey = (class$org$freehep$graphicsio$java$JAVAGraphics2D == null ? (class$org$freehep$graphicsio$java$JAVAGraphics2D = JAVAGraphics2D.class$("org.freehep.graphicsio.java.JAVAGraphics2D")) : class$org$freehep$graphicsio$java$JAVAGraphics2D).getName();
    public static final String PACKAGE_NAME = rootKey + ".PackageName";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 1.12 $";
    static /* synthetic */ Class class$org$freehep$graphicsio$java$JAVAGraphics2D;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public JAVAGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
        this.init(file);
    }

    public JAVAGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
        this.init(file);
    }

    public JAVAGraphics2D(OutputStream os, Dimension size) {
        this.init(os);
        this.width = size.width;
        this.height = size.height;
    }

    public JAVAGraphics2D(OutputStream os, Component component) {
        this.init(os);
        this.width = component.getWidth();
        this.height = component.getHeight();
        this.font = component.getFont();
        this.color = component.getForeground();
        this.paint = component.getForeground();
        this.backgroundColor = component.getBackground();
    }

    private void init(File file) {
        this.init();
        this.className = file.getName().substring(0, file.getName().lastIndexOf(".java"));
    }

    private void init(OutputStream os) {
        this.init();
        this.vg.put(this, new Integer(this.vgIndex.getInt()));
        this.lineWriter = new LineNumberWriter(new OutputStreamWriter(os));
        this.lineWriter.setLineNumber(1);
        this.out = new IndentPrintWriter(this.lineWriter);
        this.out.setIndentString("    ");
        try {
            this.lineWriter.addLineNumberListener(this, 200);
        }
        catch (TooManyListenersException tmle) {
            System.err.println(tmle);
        }
    }

    private void init() {
        this.properties = new UserProperties();
        this.isDeviceIndependent = false;
        this.composite = AlphaComposite.getInstance(3);
    }

    protected JAVAGraphics2D(JAVAGraphics2D graphics) {
        this.vg = graphics.vg;
        this.vgIndex = graphics.vgIndex;
        this.paintSequenceNo = graphics.paintSequenceNo;
        this.blockLevel = graphics.blockLevel;
        this.properties = graphics.properties;
        this.width = graphics.width;
        this.height = graphics.height;
        this.className = graphics.className;
        this.out = graphics.out;
        this.backgroundColor = graphics.backgroundColor;
        this.color = graphics.color;
        this.paint = graphics.paint;
        this.creator = graphics.creator;
        int colorMode = graphics.colorMode;
        this.stroke = graphics.stroke;
        this.transform = graphics.transform;
        this.hints = graphics.hints;
        this.isDeviceIndependent = graphics.isDeviceIndependent;
        this.composite = graphics.composite;
        this.clip = graphics.clip;
        this.font = graphics.font;
        this.vgIndex.set(this.vgIndex.getInt() + 1);
        this.vg.put(this, new Integer(this.vgIndex.getInt()));
    }

    public void setProperties(Properties newProperties) {
        if (newProperties == null) {
            return;
        }
        this.properties.setProperties(newProperties);
    }

    protected void initProperties(Properties defaults) {
        this.properties = new UserProperties();
        this.properties.setProperties(defaults);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Color getPropertyColor(String key) {
        return this.properties.getPropertyColor(key);
    }

    public Rectangle getPropertyRectangle(String key) {
        return this.properties.getPropertyRectangle(key);
    }

    public Insets getPropertyInsets(String key) {
        return this.properties.getPropertyInsets(key);
    }

    public Dimension getPropertyDimension(String key) {
        return this.properties.getPropertyDimension(key);
    }

    public int getPropertyInt(String key) {
        return this.properties.getPropertyInt(key);
    }

    public double getPropertyDouble(String key) {
        return this.properties.getPropertyDouble(key);
    }

    public boolean isProperty(String key) {
        return this.properties.isProperty(key);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".clearRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void clipRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".clipRect(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle(x, y, width, height);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.out.println(this.vg() + ".copyArea(" + x + ", " + y + ", " + width + ", " + height + ", " + dx + ", " + dy + ");");
    }

    public Graphics create() {
        JAVAGraphics2D g = new JAVAGraphics2D(this);
        this.out.println(g.vg() + " = (VectorGraphics)" + this.vg() + ".create();");
        return g;
    }

    public Graphics create(int x, int y, int width, int height) {
        JAVAGraphics2D g = new JAVAGraphics2D(this);
        this.out.println(g.vg() + " = (VectorGraphics)" + this.vg() + ".create(" + x + ", " + y + ", " + width + ", " + height + ");");
        return g;
    }

    public Graphics create(double x, double y, double width, double height) {
        JAVAGraphics2D g = new JAVAGraphics2D(this);
        this.out.println(g.vg() + " = (VectorGraphics)" + this.vg() + ".create(" + x + ", " + y + ", " + width + ", " + height + ");");
        return g;
    }

    public void dispose() {
        this.out.println(this.vg() + ".dispose();");
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.out.println(this.vg() + ".draw3DRect(" + x + ", " + y + ", " + width + ", " + height + ", " + raised + ");");
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.out.println(this.vg() + ".fill3DRect(" + x + ", " + y + ", " + width + ", " + height + ", " + raised + ");");
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.out.println(this.vg() + ".drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.out.println(this.vg() + ".drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.out.print(this.vg() + ".drawBytes(");
        this.write(data, offset + length);
        this.out.println(", " + offset + ", " + length + ", " + x + ", " + y + ");");
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.block();
        this.out.print(this.vg() + ".drawChars(");
        this.write(data, offset + length);
        this.unblock();
        this.out.println(", " + offset + ", " + length + ", " + x + ", " + y + ");");
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + "null" + ");");
        return true;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + width + ", " + height + ", " + "null" + ");");
        return true;
    }

    public boolean drawImage(Image image, int x, int y, Color bgColor, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + x + ", " + y + ", ");
        this.write(bgColor);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgColor, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + x + ", " + y + ", " + width + ", " + height + ", ");
        this.write(bgColor);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + dx1 + ", " + dy1 + ", " + dx2 + ", " + dy2);
        this.out.print(", " + sx1 + ", " + sy1 + ", " + sx2 + ", " + sy2);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgColor, ImageObserver observer) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(image);
        this.out.print(", " + dx1 + ", " + dy1 + ", " + dx2 + ", " + dy2);
        this.out.print(", " + sx1 + ", " + sy1 + ", " + sx2 + ", " + sy2 + ", ");
        this.write(bgColor);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.out.println(this.vg() + ".drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ");");
    }

    public void drawOval(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".drawOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillOval(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".fillOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".fillPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawPolygon(Polygon p) {
        this.block();
        this.out.print(this.vg() + ".drawPolygon(");
        this.write(p);
        this.unblock();
        this.out.println(");");
    }

    public void fillPolygon(Polygon p) {
        this.block();
        this.out.print(this.vg() + ".fillPolygon(");
        this.write(p);
        this.unblock();
        this.out.println(");");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolyline(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".drawRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillRect(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".fillRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.out.println(this.vg() + ".drawRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.out.println(this.vg() + ".fillRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.out.println("System.err.println(\"" + this.getClass() + ": drawString(AttributedCharacterIterator, int int) not implemented.\");");
    }

    public void drawString(String str, int x, int y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void finalize() {
        this.out.println(this.vg() + ".finalize();");
    }

    public Shape getClip() {
        return this.clip;
    }

    public Rectangle getClipBounds() {
        return this.clip == null ? null : this.clip.getBounds();
    }

    public Rectangle getClipBounds(Rectangle r) {
        Rectangle c = this.getClipBounds();
        if (c != null) {
            r.x = c.x;
            r.y = c.y;
            r.width = c.width;
            r.height = c.height;
        }
        return r;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return this.clip.intersects(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.out.println(this.vg() + ".setClip(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle(x, y, width, height);
    }

    public void setClip(Shape clip) {
        this.block();
        this.out.print(this.vg() + ".setClip(");
        this.write(clip);
        this.unblock();
        this.out.println(");");
        this.clip = clip;
    }

    public void setColor(Color c) {
        this.block();
        this.out.print(this.vg() + ".setColor(");
        this.write(c);
        this.unblock();
        this.out.println(");");
        this.color = c;
    }

    public void setFont(Font font) {
        this.block();
        this.out.print(this.vg() + ".setFont(");
        this.write(font);
        this.unblock();
        this.out.println(");");
        this.font = font;
    }

    public void setPaintMode() {
        this.out.println(this.vg() + ".setPaintMode();");
    }

    public void setXORMode(Color c1) {
        this.block();
        this.out.print(this.vg() + ".setXORMode(");
        this.write(c1);
        this.unblock();
        this.out.println(");");
    }

    public String toString() {
        return "JavaGraphics2D";
    }

    public void translate(int x, int y) {
        this.out.println(this.vg() + ".translate(" + x + ", " + y + ");");
    }

    public void addRenderingHints(Map hints) {
        hints.putAll(hints);
    }

    public void clip(Shape s) {
        this.block();
        this.out.print(this.vg() + ".clip(");
        this.write(s);
        this.unblock();
        this.out.println(");");
        this.clip = s;
    }

    public void draw(Shape s) {
        this.block();
        this.out.print(this.vg() + ".draw(");
        this.write(s);
        this.unblock();
        this.out.println(");");
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.out.println("System.err.println(\"" + this.getClass() + ": drawGlyphVector(GlyphVector, float, float) not implemented.\");");
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.out.println("System.err.println(\"" + this.getClass() + ": drawImage(BufferedImage, BufferedImageOp, int, int) not implemented.\");");
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.block();
        this.out.print(this.vg() + ".drawImage(");
        this.write(img);
        this.out.print(", ");
        this.write(xform);
        this.unblock();
        this.out.println(", null);");
        return true;
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.out.println("System.err.println(\"" + this.getClass() + ": drawRenderableImage(RenderableImage, AffineTransform) not implemented.\");");
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.out.println("System.err.println(\"" + this.getClass() + ": drawRenderedImage(RenderedImage, AffineTransform) not implemented.\");");
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.out.println("System.err.println(\"" + this.getClass() + ": drawString(AttributedCharacterIterator, float, float) not implemented.\");");
    }

    public void drawString(String str, float x, float y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void fill(Shape s) {
        this.block();
        this.out.print(this.vg() + ".fill(");
        this.write(s);
        this.unblock();
        this.out.println(");");
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(), false, false);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.out.println("System.err.println(\"" + this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.\");");
        return false;
    }

    public void rotate(double theta) {
        this.out.println(this.vg() + ".rotate(" + theta + ");");
    }

    public void rotate(double theta, double x, double y) {
        this.out.println(this.vg() + ".rotate(" + theta + ", " + x + ", " + y + ");");
    }

    public void scale(double sx, double sy) {
        this.out.println(this.vg() + ".scale(" + sx + ", " + sy + ");");
    }

    public void setBackground(Color c) {
        this.block();
        this.out.print(this.vg() + ".setBackground(");
        this.write(c);
        this.unblock();
        this.out.println(");");
        this.backgroundColor = c;
    }

    public void setComposite(Composite c) {
        if (c instanceof AlphaComposite) {
            this.block();
            this.out.print(this.vg() + ".setComposite(");
            this.write((AlphaComposite)c);
            this.unblock();
            this.out.println(");");
        } else {
            this.out.println("System.err.println(\"" + this.getClass() + ": setComposite(Composite) not implemented.\");");
        }
        this.composite = c;
    }

    public void setPaint(Paint p) {
        if (p instanceof Color) {
            this.block();
            this.out.print(this.vg() + ".setPaint(");
            this.write((Color)p);
            this.unblock();
            this.out.println(");");
        } else if (p instanceof GradientPaint) {
            this.block();
            this.out.print(this.vg() + ".setPaint(");
            this.write((GradientPaint)p);
            this.unblock();
            this.out.println(");");
        } else if (p instanceof TexturePaint) {
            this.block();
            this.out.print(this.vg() + ".setPaint(");
            this.write((TexturePaint)p);
            this.unblock();
            this.out.println(");");
        } else {
            this.out.println("System.err.println(\"" + this.getClass() + ": setPaint(Paint) not implemented.\");");
        }
        this.paint = p;
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    public void setRenderingHints(Map hints) {
        this.hints = new RenderingHints(hints);
    }

    public void setStroke(Stroke s) {
        if (s instanceof BasicStroke) {
            this.block();
            this.out.print(this.vg() + ".setStroke(");
            this.write((BasicStroke)s);
            this.unblock();
            this.out.println(");");
        } else {
            this.out.println("System.err.println(\"" + this.getClass() + ": setStroke(Stroke) not implemented.\");");
        }
        this.stroke = s;
    }

    public void setTransform(AffineTransform xform) {
        this.block();
        this.out.print(this.vg() + ".setTransform(");
        this.write(xform);
        this.unblock();
        this.out.println(");");
    }

    public void shear(double shx, double shy) {
        this.out.println(this.vg() + ".shear(" + shx + ", " + shy + ");");
    }

    public void transform(AffineTransform xform) {
        this.block();
        this.out.print(this.vg() + ".transform(");
        this.write(xform);
        this.unblock();
        this.out.println(");");
    }

    public void translate(double tx, double ty) {
        this.out.println(this.vg() + ".translate(" + tx + ", " + ty + ");");
    }

    public void clearRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".clearRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void clipRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".clipRect(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle2D.Double(x, y, width, height);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.out.println(this.vg() + ".drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.out.println(this.vg() + ".drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ");");
    }

    public void drawOval(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".drawOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".drawPolyline(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void drawRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".drawRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.out.println(this.vg() + ".drawRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public void drawSymbol(int x, int y, int size, int symbol) {
        this.out.println(this.vg() + ".drawSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void drawSymbol(double x, double y, double size, int symbol) {
        this.out.println(this.vg() + ".drawSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void fillSymbol(int x, int y, int size, int symbol) {
        this.out.println(this.vg() + ".fillSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void fillSymbol(double x, double y, double size, int symbol) {
        this.out.println(this.vg() + ".fillSymbol(" + x + ", " + y + ", " + size + ", " + symbol + ");");
    }

    public void drawString(String str, double x, double y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void drawString(TagString str, double x, double y) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ");");
    }

    public void drawString(String str, double x, double y, int horizontal, int vertical) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ");");
    }

    public void drawString(TagString str, double x, double y, int horizontal, int vertical) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.unblock();
        this.out.println(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ");");
    }

    public void drawString(String str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.out.print(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ", " + framed + ", ");
        this.write(frameColor);
        this.out.print(", " + frameWidth + ", " + banner + ", ");
        this.write(bannerColor);
        this.unblock();
        this.out.println(");");
    }

    public void drawString(TagString str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        this.block();
        this.out.print(this.vg() + ".drawString(");
        this.write(str);
        this.out.print(", " + x + ", " + y + ", " + horizontal + ", " + vertical + ", " + framed + ", ");
        this.write(frameColor);
        this.out.print(", " + frameWidth + ", " + banner + ", ");
        this.write(bannerColor);
        this.unblock();
        this.out.println(");");
    }

    public void fillAndDraw(Shape s, Color fillColor) {
        this.block();
        this.out.print(this.vg() + ".fillAndDraw(");
        this.write(s);
        this.out.print(", ");
        this.write(fillColor);
        this.unblock();
        this.out.println(");");
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.out.println(this.vg() + ".fillArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ");");
    }

    public void fillOval(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".fillOval(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.block();
        this.out.print(this.vg() + ".fillPolygon(");
        this.write(xPoints);
        this.out.print(", ");
        this.write(yPoints);
        this.unblock();
        this.out.println(", " + nPoints + ");");
    }

    public void fillRect(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".fillRect(" + x + ", " + y + ", " + width + ", " + height + ");");
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.out.println(this.vg() + ".fillRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ");");
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public String getCreator() {
        return this.creator;
    }

    public boolean isDeviceIndependent() {
        return false;
    }

    public void printComment(String comment) {
        this.block();
        this.out.print(this.vg() + ".printComment(");
        this.write(comment);
        this.unblock();
        this.out.println(");");
    }

    public void setClip(double x, double y, double width, double height) {
        this.out.println(this.vg() + ".setClip(" + x + ", " + y + ", " + width + ", " + height + ");");
        this.clip = new Rectangle2D.Double(x, y, width, height);
    }

    public void setColorMode(int colorMode) {
        this.out.println(this.vg() + ".setColorMode(" + colorMode + ");");
        this.colorMode = colorMode;
    }

    public void setCreator(String creator) {
        if (creator != null) {
            this.creator = creator;
        }
    }

    public void setDeviceIndependent(boolean isDeviceIndependent) {
        this.isDeviceIndependent = true;
    }

    public void setLineWidth(int width) {
        this.out.println(this.vg() + ".setLineWidth(" + width + ");");
    }

    public void setLineWidth(double width) {
        this.out.println(this.vg() + ".setLineWidth(" + width + ");");
    }

    public void startExport() {
        this.block();
        this.out.println("// AUTOMATICALLY GENERATED by " + this.creator);
        this.out.println();
        if (this.getProperty(PACKAGE_NAME) != null && !this.getProperty(PACKAGE_NAME).equals("")) {
            this.out.println("package " + this.getProperty(PACKAGE_NAME) + ";");
            this.out.println();
        }
        this.out.println("import java.awt.*;");
        this.out.println("import java.awt.geom.*;");
        this.out.println("import java.awt.image.*;");
        this.out.println("import javax.swing.*;");
        this.out.println("import org.freehep.graphics2d.*;");
        this.out.println("import org.freehep.graphicsio.java.*;");
        this.out.println("import org.freehep.graphicsio.test.*;");
        this.out.println();
        this.out.println("public class " + this.className + " extends TestingPanel {");
        this.out.println();
        this.out.indent();
        this.out.println("public " + this.className + "(String[] args) throws Exception {");
        this.out.indent();
        this.out.println("super(args);");
        this.out.print("setName(");
        this.write(this.className);
        this.out.println(");");
        this.out.outdent();
        this.out.println("} // contructor");
        this.out.println();
        this.out.println("public void paint(Graphics g) {");
        this.out.indent();
        this.out.println("vg[0] = VectorGraphics.create(g);");
        this.out.print("vg[0].setCreator(");
        this.write(this.creator);
        this.out.println(");");
        this.out.println("Paint0s" + this.paintSequenceNo.getInt() + ".paint(vg);");
        this.out.outdent();
        this.out.println("} // paint");
        this.out.println();
        this.startClass();
        this.unblock();
    }

    public void endExport() {
        this.block();
        this.endClass();
        this.out.println("private VectorGraphics vg[] = new VectorGraphics[" + this.vg.size() + "];");
        this.out.println();
        this.out.println("public static void main(String[] args) throws Exception {");
        this.out.indent();
        this.out.println("new " + this.className + "(args).runTest(" + this.width + ", " + this.height + ");");
        this.out.outdent();
        this.out.println("}");
        this.out.outdent();
        this.out.println("} // class");
        this.out.close();
        this.unblock();
    }

    public void lineNumberReached(LineNumberWriter.LineNumberEvent event) {
        if (!this.block()) {
            this.lineWriter.setLineNumber(1);
            this.out.println("Paint0s" + (this.paintSequenceNo.getInt() + 1) + ".paint(vg);");
            this.endClass();
            this.paintSequenceNo.set(this.paintSequenceNo.getInt() + 1);
            this.startClass();
        }
        this.unblock();
    }

    private boolean block() {
        boolean blocked = this.blockLevel.getInt() > 0;
        this.blockLevel.set(this.blockLevel.getInt() + 1);
        return blocked;
    }

    private void unblock() {
        if (this.blockLevel.getInt() > 0) {
            this.blockLevel.set(this.blockLevel.getInt() - 1);
        }
    }

    private void startClass() {
        this.block();
        this.out.println("private static class Paint0s" + this.paintSequenceNo.getInt() + " {");
        this.out.indent();
        this.out.println("public static void paint(VectorGraphics[] vg) {");
        this.out.indent();
        this.unblock();
    }

    private void endClass() {
        this.block();
        this.out.outdent();
        this.out.println("} // paint");
        this.out.outdent();
        this.out.println("} // class Paint0s" + this.paintSequenceNo.getInt());
        this.out.println();
        this.unblock();
    }

    private void write(Color c) {
        if (c == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new Color(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ")");
    }

    private void write(Font font) {
        if (font == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new Font(");
        this.write(font.getName());
        this.out.print(", " + font.getStyle() + ", " + font.getSize() + ")");
    }

    private void write(AffineTransform t) {
        if (t == null) {
            this.out.print("null");
            return;
        }
        double[] m = new double[6];
        t.getMatrix(m);
        this.out.print("new AffineTransform(" + m[0] + ", " + m[1] + ", " + m[2] + ", " + m[3] + ", " + m[4] + ", " + m[5] + ")");
    }

    private void write(Shape s) {
        if (s == null) {
            this.out.print("null");
            return;
        }
        PathIterator i = s.getPathIterator(null);
        this.out.println("new JAVAGeneralPath(" + i.getWindingRule() + ", new JAVAGeneralPath.PathElement[] {");
        this.out.indent();
        float[] c = new float[6];
        while (!i.isDone()) {
            int type = i.currentSegment(c);
            switch (type) {
                case 0: {
                    this.out.print("new JAVAGeneralPath.MoveTo(" + c[0] + "f, " + c[1] + "f)");
                    break;
                }
                case 1: {
                    this.out.print("new JAVAGeneralPath.LineTo(" + c[0] + "f, " + c[1] + "f)");
                    break;
                }
                case 3: {
                    this.out.print("new JAVAGeneralPath.CurveTo(" + c[0] + "f, " + c[1] + "f, " + c[2] + "f, " + c[3] + "f, " + c[4] + "f, " + c[5] + "f)");
                    break;
                }
                case 2: {
                    this.out.print("new JAVAGeneralPath.QuadTo(" + c[0] + "f, " + c[1] + "f, " + c[2] + "f, " + c[3] + "f)");
                    break;
                }
                case 4: {
                    this.out.print("new JAVAGeneralPath.ClosePath()");
                    break;
                }
            }
            i.next();
            this.out.println(i.isDone() ? "" : ",");
        }
        this.out.outdent();
        this.out.print("})");
    }

    private void write(double[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(double[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new double[] {");
        this.out.indent();
        int i = 0;
        while (i < length) {
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print(a[i]);
            ++i;
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(float[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(float[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new float[] {");
        this.out.indent();
        int i = 0;
        while (i < length) {
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print(a[i] + "f");
            ++i;
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(int[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(int[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new int[] {");
        this.out.indent();
        int i = 0;
        while (i < length) {
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print(a[i]);
            ++i;
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(byte[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(byte[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new byte[] {");
        this.out.indent();
        int i = 0;
        while (i < length) {
            if (i != 0) {
                this.out.print(", ");
            }
            this.out.print("(byte)0x" + Integer.toHexString(a[i]));
            ++i;
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(char[] a) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.write(a, a.length);
    }

    private void write(char[] a, int length) {
        if (a == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new char[] {");
        this.out.indent();
        int i = 0;
        while (i < length) {
            if (i != 0) {
                this.out.print(", ");
            }
            char c = a[i];
            this.out.print("'");
            switch (c) {
                case '\b': {
                    this.out.print("\\b");
                    break;
                }
                case '\t': {
                    this.out.print("\\t");
                    break;
                }
                case '\n': {
                    this.out.print("\\n");
                    break;
                }
                case '\f': {
                    this.out.print("\\f");
                    break;
                }
                case '\r': {
                    this.out.print("\\r");
                    break;
                }
                case '\"': {
                    this.out.print("\\\"");
                    break;
                }
                case '\'': {
                    this.out.print("\\'");
                    break;
                }
                case '\\': {
                    this.out.print("\\\\");
                    break;
                }
                default: {
                    this.out.print(this.toUnicode(c));
                }
            }
            this.out.print("'");
            ++i;
        }
        this.out.outdent();
        this.out.println();
        this.out.print("}");
    }

    private void write(Polygon p) {
        if (p == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new Polygon(");
        this.out.indent();
        this.write(p.xpoints, p.npoints);
        this.out.print(", ");
        this.write(p.ypoints, p.npoints);
        this.out.println(", " + p.npoints);
        this.out.outdent();
        this.out.print(")");
    }

    private void write(Image image) {
        if (image == null) {
            this.out.print("null");
            return;
        }
        PNGEncoder encoder = new PNGEncoder(image, true, 0, 9);
        byte[] data = encoder.pngEncode();
        this.out.print("new BufferedImage(" + image.getWidth(null) + ", " + image.getHeight(null) + ", BufferedImage.TYPE_INT_ARGB)");
    }

    private void write(GradientPaint gp) {
        if (gp == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new GradientPaint(");
        this.out.indent();
        this.write(gp.getPoint1());
        this.out.print(", ");
        this.write(gp.getColor1());
        this.out.println(", ");
        this.write(gp.getPoint2());
        this.out.print(", ");
        this.write(gp.getColor2());
        this.out.println(", " + gp.isCyclic());
        this.out.outdent();
        this.out.print(")");
    }

    private void write(TexturePaint tp) {
        if (tp == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new TexturePaint(");
        this.out.indent();
        this.out.println("(BufferedImage)");
        this.write(tp.getImage());
        this.out.print(", ");
        this.write(tp.getAnchorRect());
        this.out.outdent();
        this.out.print(")");
    }

    private void write(BasicStroke bs) {
        if (bs == null) {
            this.out.print("null");
            return;
        }
        this.out.println("new BasicStroke(");
        this.out.indent();
        this.out.println(bs.getLineWidth() + "f, " + bs.getEndCap() + ", ");
        this.out.println(bs.getLineJoin() + ", " + bs.getMiterLimit() + "f, ");
        this.write(bs.getDashArray());
        this.out.println(", " + bs.getDashPhase() + "f");
        this.out.outdent();
        this.out.print(")");
    }

    private void write(AlphaComposite ac) {
        if (ac == null) {
            this.out.print("null");
            return;
        }
        this.out.print("AlphaComposite.getInstance(" + ac.getRule() + ", " + ac.getAlpha() + ")");
    }

    private void write(Point2D p) {
        if (p == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new Point2D.Double(" + p.getX() + ", " + p.getY() + ")");
    }

    private void write(Rectangle2D r) {
        if (r == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new Rectangle2D.Double(" + r.getX() + ", " + r.getY() + ", " + r.getWidth() + ", " + r.getHeight() + ")");
    }

    private void write(String s) {
        if (s == null) {
            this.out.print("(String)null");
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                default: {
                    sb.append(this.toUnicode(c));
                }
            }
            ++i;
        }
        this.out.print("\"" + sb.toString() + "\"");
    }

    private void write(TagString s) {
        if (s == null) {
            this.out.print("null");
            return;
        }
        this.out.print("new TagString(");
        this.write(s.toString());
        this.out.print(")");
    }

    private String vg() {
        Integer index = (Integer)this.vg.get(this);
        return "vg[" + (index != null ? String.valueOf(index) : "null") + "]";
    }

    private String toUnicode(char c) {
        if (c <= '\u001f' || '\u007f' <= c) {
            String unicode = "0000" + Integer.toHexString(c);
            return "\\u" + unicode.substring(unicode.length() - 4);
        }
        return String.valueOf(c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultProperties.setProperty(PACKAGE_NAME, "");
    }
}

