/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Font;
import java.util.Stack;
import org.freehep.graphics2d.TagHandler;
import org.freehep.graphics2d.TagString;

public class PSTagHandler
extends TagHandler {
    String baseFont = "";
    private int fontSize;
    private Stack fStack = new Stack();
    private Stack vStack = new Stack();
    private final String UNSTYLED = "";
    private final String BOLD = "B";
    private final String ITALIC = "I";
    private final String BOLD_ITALIC = "BI";
    private final String UNSTYLED_FLAG = "\\340\\000";
    private final String BOLD_CHAR = "\\340\\001";
    private final String ITALIC_CHAR = "\\340\\002";
    private final String BOLD_ITALIC_CHAR = "\\340\\003";
    private final String SUPERSUBSCRIPT_FLAG = "\\360\\000";
    private final String STRIKEOUT_FLAG = "\\360\\001";
    private final String UNDERLINE_FLAG = "\\360\\002";
    private final String DASHED_UNDERLINE_FLAG = "\\360\\003";
    private final String DOTTED_UNDERLINE_FLAG = "\\360\\004";
    private final String GRAY_UNDERLINE_FLAG = "\\360\\005";
    private final String THICK_UNDERLINE_FLAG = "\\360\\006";
    private final String OVERLINE_FLAG = "\\360\\007";
    private final String BEGIN_GROUP = "\\360\\376";
    private final String END_GROUP = "\\360\\377";

    public PSTagHandler(Font font) {
        this.fStack.push("");
        this.vStack.push(Boolean.FALSE);
        StringBuffer psFont = new StringBuffer("cfont");
        String fontName = font.getName();
        fontName = fontName.toLowerCase();
        if (fontName.indexOf("helvetica") >= 0) {
            psFont.append("H");
        } else if (fontName.indexOf("sansserif") >= 0) {
            psFont.append("H");
        } else if (fontName.indexOf("times") >= 0) {
            psFont.append("T");
        } else if (fontName.indexOf("serif") >= 0) {
            psFont.append("T");
        } else if (fontName.indexOf("courier") >= 0) {
            psFont.append("C");
        } else {
            psFont.append("H");
        }
        this.baseFont = psFont.toString();
        this.fontSize = font.getSize();
    }

    public String parse(TagString string) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fontSize + " " + this.baseFont + "\n(");
        buffer.append(super.parse(string));
        buffer.append(")");
        return buffer.toString();
    }

    protected String text(String str) {
        StringBuffer codedString = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char chr = str.charAt(i);
            int cvalue = chr & 0xFF;
            int fvalue = (chr & 0xFF00) >>> 8;
            String cbyte = Integer.toOctalString(cvalue);
            String fbyte = Integer.toOctalString(fvalue);
            codedString.append('\\');
            int j = 0;
            while (j < 3 - fbyte.length()) {
                codedString.append('0');
                ++j;
            }
            codedString.append(fbyte);
            if (cvalue < 32 || cvalue > 126 || cvalue == 92 || cvalue == 37 || cvalue == 40 || cvalue == 41) {
                codedString.append('\\');
                int j2 = 0;
                while (j2 < 3 - cbyte.length()) {
                    codedString.append('0');
                    ++j2;
                }
                codedString.append(cbyte);
            } else {
                codedString.append((char)cvalue);
            }
            ++i;
        }
        return codedString.toString();
    }

    protected String openTag(String tag) {
        StringBuffer tagString = new StringBuffer();
        if (tag.equalsIgnoreCase("b")) {
            if (this.fStack.peek() == "I" || this.fStack.peek() == "BI") {
                this.fStack.push("BI");
                tagString.append("\\340\\003");
            } else {
                this.fStack.push("B");
                tagString.append("\\340\\001");
            }
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("i")) {
            if (this.fStack.peek() == "B" || this.fStack.peek() == "BI") {
                this.fStack.push("BI");
                tagString.append("\\340\\003");
            } else {
                this.fStack.push("I");
                tagString.append("\\340\\002");
            }
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("v")) {
            this.vStack.push(Boolean.TRUE);
            tagString.append("\\360\\000");
        } else if (tag.equalsIgnoreCase("sup")) {
            if (!((Boolean)this.vStack.peek()).booleanValue()) {
                tagString.append("\\360\\000");
            }
            tagString.append("\\360\\376");
            this.vStack.push(Boolean.FALSE);
        } else if (tag.equalsIgnoreCase("sub")) {
            if (!((Boolean)this.vStack.peek()).booleanValue()) {
                tagString.append("\\360\\000");
                tagString.append("\\360\\376");
                tagString.append("\\360\\377");
            }
            tagString.append("\\360\\376");
            this.vStack.push(Boolean.FALSE);
        } else if (tag.equalsIgnoreCase("u")) {
            tagString.append("\\360\\002");
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("udash")) {
            tagString.append("\\360\\003");
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("udot")) {
            tagString.append("\\360\\004");
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("uthick")) {
            tagString.append("\\360\\006");
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("ugray")) {
            tagString.append("\\360\\005");
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("strike")) {
            tagString.append("\\360\\001");
            tagString.append("\\360\\376");
        } else if (tag.equalsIgnoreCase("over")) {
            tagString.append("\\360\\007");
            tagString.append("\\360\\376");
        }
        return tagString.toString();
    }

    protected String closeTag(String tag) {
        StringBuffer tagString = new StringBuffer();
        if (tag.equalsIgnoreCase("b")) {
            tagString.append("\\360\\377");
            this.fStack.pop();
        } else if (tag.equalsIgnoreCase("i")) {
            tagString.append("\\360\\377");
            this.fStack.pop();
        } else if (tag.equalsIgnoreCase("v")) {
            this.vStack.pop();
        } else if (tag.equalsIgnoreCase("sup")) {
            this.vStack.pop();
            if (!((Boolean)this.vStack.peek()).booleanValue()) {
                tagString.append("\\360\\377");
                tagString.append("\\360\\376");
            }
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("sub")) {
            this.vStack.pop();
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("u")) {
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("udash")) {
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("udot")) {
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("uthick")) {
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("ugray")) {
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("strike")) {
            tagString.append("\\360\\377");
        } else if (tag.equalsIgnoreCase("over")) {
            tagString.append("\\360\\377");
        }
        return tagString.toString();
    }
}

