/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class ColorXform {
    private int rx = 256;
    private int gx = 256;
    private int bx = 256;
    private int ax = 256;
    private int rp = 0;
    private int gp = 0;
    private int bp = 0;
    private int ap = 0;

    public ColorXform(int rx, int gx, int bx, int ax, int rp, int gp, int bp, int ap) {
        this.rx = rx;
        this.gx = gx;
        this.bx = bx;
        this.ax = ax;
        this.rp = rp;
        this.gp = gp;
        this.bp = bp;
        this.ap = ap;
    }

    public ColorXform(SWFInputStream swf, boolean hasAlpha) throws IOException {
        swf.byteAlign();
        boolean add = swf.readBitFlag();
        boolean mult = swf.readBitFlag();
        int nbits = (int)swf.readUBits(4);
        if (mult) {
            this.rx = (int)swf.readSBits(nbits);
            this.gx = (int)swf.readSBits(nbits);
            this.bx = (int)swf.readSBits(nbits);
            if (hasAlpha) {
                this.ax = (int)swf.readSBits(nbits);
            }
        }
        if (add) {
            this.rp = (int)swf.readSBits(nbits);
            this.gp = (int)swf.readSBits(nbits);
            this.bp = (int)swf.readSBits(nbits);
            if (hasAlpha) {
                this.ap = (int)swf.readSBits(nbits);
            }
        }
    }

    public Color transform(Color c) {
        int red = (int)Math.max(0.0, Math.min((double)(c.getRed() * this.rx) / 256.0 + (double)this.rp, 255.0));
        int green = (int)Math.max(0.0, Math.min((double)(c.getGreen() * this.gx) / 256.0 + (double)this.gp, 255.0));
        int blue = (int)Math.max(0.0, Math.min((double)(c.getBlue() * this.bx) / 256.0 + (double)this.bp, 255.0));
        int alpha = (int)Math.max(0.0, Math.min((double)(c.getAlpha() * this.ax) / 256.0 + (double)this.ap, 255.0));
        return new Color(red, green, blue, alpha);
    }

    public void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        swf.byteAlign();
        boolean add = this.rp != 0 || this.gp != 0 || this.bp != 0 || hasAlpha && this.ap != 0;
        boolean mult = this.rx != 1 || this.gx != 1 || this.bx != 1 || hasAlpha && this.ax != 1;
        int nbits = 0;
        if (mult) {
            nbits = Math.max(nbits, SWFOutputStream.minBits(this.rx, true));
            nbits = Math.max(nbits, SWFOutputStream.minBits(this.gx, true));
            nbits = Math.max(nbits, SWFOutputStream.minBits(this.bx, true));
            if (hasAlpha) {
                nbits = Math.max(nbits, SWFOutputStream.minBits(this.ax, true));
            }
        }
        if (add) {
            nbits = Math.max(nbits, SWFOutputStream.minBits(this.rp, true));
            nbits = Math.max(nbits, SWFOutputStream.minBits(this.gp, true));
            nbits = Math.max(nbits, SWFOutputStream.minBits(this.bp, true));
            if (hasAlpha) {
                nbits = Math.max(nbits, SWFOutputStream.minBits(this.ap, true));
            }
        }
        swf.writeBitFlag(add);
        swf.writeBitFlag(mult);
        swf.writeUBits(nbits, 4);
        if (mult) {
            swf.writeSBits(this.rx, nbits);
            swf.writeSBits(this.gx, nbits);
            swf.writeSBits(this.bx, nbits);
            if (hasAlpha) {
                swf.writeSBits(this.ax, nbits);
            }
        }
        if (add) {
            swf.writeSBits(this.rp, nbits);
            swf.writeSBits(this.gp, nbits);
            swf.writeSBits(this.bp, nbits);
            if (hasAlpha) {
                swf.writeSBits(this.ap, nbits);
            }
        }
    }

    public String toString() {
        return "CXForm(" + this.rx + ", " + this.gx + ", " + this.bx + ", " + this.ax + " : " + this.rp + ", " + this.gp + ", " + this.bp + ", " + this.ap + ")";
    }
}

