/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.freehep.graphicsio.swf.DefineFontInfo;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFont
extends DefinitionTag {
    private int character;
    private List shapes;
    private DefineFontInfo info;

    public DefineFont(int id) {
        this();
        this.character = id;
        this.shapes = new ArrayList();
    }

    public void add(SWFShape shape) {
        this.shapes.add(shape);
    }

    public DefineFont() {
        super(10, 1);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineFont tag = new DefineFont();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        int offset0 = swf.readUnsignedShort();
        int glyphCount = offset0 / 2;
        int[] offsets = new int[glyphCount];
        offsets[0] = offset0;
        int i = 1;
        while (i < glyphCount) {
            offsets[i] = swf.readUnsignedShort();
            ++i;
        }
        tag.shapes = new ArrayList();
        int i2 = 0;
        while (i2 < glyphCount) {
            tag.shapes.add(new SWFShape(swf));
            ++i2;
        }
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.pushBuffer();
        int[] offsets = new int[this.shapes.size()];
        int i = 0;
        while (i < this.shapes.size()) {
            offsets[i] = swf.getBufferLength();
            ((SWFShape)this.shapes.get(i)).write(swf);
            ++i;
        }
        swf.popBuffer();
        int i2 = 0;
        while (i2 < this.shapes.size()) {
            swf.writeUnsignedShort(this.shapes.size() * 2 + offsets[i2]);
            ++i2;
        }
        swf.append();
    }

    public int getGlyphCount() {
        return this.shapes.size();
    }

    public void setFontInfo(DefineFontInfo info) {
        this.info = info;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  glyphcount: " + this.shapes.size() + "\n");
        int i = 0;
        while (i < this.shapes.size()) {
            s.append(this.shapes.get(i) + "\n");
            ++i;
        }
        s.append("  fontInfo: " + this.info + "\n");
        return s.toString();
    }
}

