/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.util.io.Action;
import org.freehep.util.io.TaggedInputStream;
import org.freehep.util.io.TaggedOutputStream;

public abstract class SWFAction
extends Action {
    private int version;

    protected SWFAction(int code, int version) {
        super(code);
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public Action read(int actionCode, TaggedInputStream input, int length) throws IOException {
        return this.read(actionCode, (SWFInputStream)input, length);
    }

    public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
        return this;
    }

    public void write(int actionCode, TaggedOutputStream input) throws IOException {
        this.write(actionCode, (SWFOutputStream)input);
    }

    public void write(int actionCode, SWFOutputStream swf) throws IOException {
    }

    public static class StringGreater
    extends SWFAction {
        public StringGreater() {
            super(104, 6);
        }
    }

    public static class Greater
    extends SWFAction {
        public Greater() {
            super(103, 6);
        }
    }

    public static class StrictEquals
    extends SWFAction {
        public StrictEquals() {
            super(102, 6);
        }
    }

    public static class Enumerate2
    extends SWFAction {
        public Enumerate2() {
            super(85, 6);
        }
    }

    public static class InstanceOf
    extends SWFAction {
        public InstanceOf() {
            super(84, 6);
        }
    }

    public static class BitURShift
    extends SWFAction {
        public BitURShift() {
            super(101, 5);
        }
    }

    public static class BitRShift
    extends SWFAction {
        public BitRShift() {
            super(100, 5);
        }
    }

    public static class BitLShift
    extends SWFAction {
        public BitLShift() {
            super(99, 5);
        }
    }

    public static class BitXor
    extends SWFAction {
        public BitXor() {
            super(98, 5);
        }
    }

    public static class BitOr
    extends SWFAction {
        public BitOr() {
            super(97, 5);
        }
    }

    public static class BitAnd
    extends SWFAction {
        public BitAnd() {
            super(96, 5);
        }
    }

    public static class NewMethod
    extends SWFAction {
        public NewMethod() {
            super(83, 5);
        }
    }

    public static class CallMethod
    extends SWFAction {
        public CallMethod() {
            super(82, 5);
        }
    }

    public static class Decrement
    extends SWFAction {
        public Decrement() {
            super(81, 5);
        }
    }

    public static class Increment
    extends SWFAction {
        public Increment() {
            super(80, 5);
        }
    }

    public static class SetMember
    extends SWFAction {
        public SetMember() {
            super(79, 5);
        }
    }

    public static class GetMember
    extends SWFAction {
        public GetMember() {
            super(78, 5);
        }
    }

    public static class StackSwap
    extends SWFAction {
        public StackSwap() {
            super(77, 5);
        }
    }

    public static class PushDuplicate
    extends SWFAction {
        public PushDuplicate() {
            super(76, 5);
        }
    }

    public static class ToString
    extends SWFAction {
        public ToString() {
            super(75, 5);
        }
    }

    public static class ToNumber
    extends SWFAction {
        public ToNumber() {
            super(74, 5);
        }
    }

    public static class Equals2
    extends SWFAction {
        public Equals2() {
            super(73, 5);
        }
    }

    public static class Less2
    extends SWFAction {
        public Less2() {
            super(72, 5);
        }
    }

    public static class Add2
    extends SWFAction {
        public Add2() {
            super(71, 5);
        }
    }

    public static class Enumerate
    extends SWFAction {
        public Enumerate() {
            super(70, 5);
        }
    }

    public static class TargetPath
    extends SWFAction {
        public TargetPath() {
            super(69, 5);
        }
    }

    public static class TypeOf
    extends SWFAction {
        public TypeOf() {
            super(68, 5);
        }
    }

    public static class InitObject
    extends SWFAction {
        public InitObject() {
            super(67, 5);
        }
    }

    public static class InitArray
    extends SWFAction {
        public InitArray() {
            super(66, 5);
        }
    }

    public static class DefineLocal2
    extends SWFAction {
        public DefineLocal2() {
            super(65, 5);
        }
    }

    public static class NewObject
    extends SWFAction {
        public NewObject() {
            super(64, 5);
        }
    }

    public static class Modulo
    extends SWFAction {
        public Modulo() {
            super(63, 5);
        }
    }

    public static class Return
    extends SWFAction {
        public Return() {
            super(62, 5);
        }
    }

    public static class CallFunction
    extends SWFAction {
        public CallFunction() {
            super(61, 5);
        }
    }

    public static class DefineLocal
    extends SWFAction {
        public DefineLocal() {
            super(60, 5);
        }
    }

    public static class Delete2
    extends SWFAction {
        public Delete2() {
            super(59, 5);
        }
    }

    public static class Delete
    extends SWFAction {
        public Delete() {
            super(58, 5);
        }
    }

    public static class DefineFunction
    extends SWFAction {
        private String name;
        private String[] params;
        private byte[] code;

        public DefineFunction(String name, String[] params, byte[] code) {
            this();
            this.name = name;
            this.params = params;
            this.code = code;
        }

        public DefineFunction() {
            super(155, 5);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            DefineFunction action = new DefineFunction();
            action.name = swf.readString();
            int n = swf.readUnsignedShort();
            int i = 0;
            while (i < n) {
                action.params[i] = swf.readString();
                ++i;
            }
            int cs = swf.readUnsignedShort();
            action.code = swf.readByte(cs);
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeString(this.name);
            swf.writeUnsignedShort(this.params.length);
            int i = 0;
            while (i < this.params.length) {
                swf.writeString(this.params[i]);
                ++i;
            }
            swf.writeUnsignedShort(this.code.length);
            swf.writeByte(this.code);
        }

        public String toString() {
            return super.toString() + ", " + this.name + ", " + new String(this.code);
        }
    }

    public static class With
    extends SWFAction {
        private int size;
        private String block;

        public With(int size, String block) {
            this();
            this.size = size;
            this.block = block;
        }

        public With() {
            super(148, 5);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            With action = new With();
            action.size = swf.readUnsignedShort();
            action.block = swf.readString();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeUnsignedShort(this.size);
            swf.writeString(this.block);
        }

        public String toString() {
            return super.toString() + ", " + this.size + ", " + this.block;
        }
    }

    public static class ConstantPool
    extends SWFAction {
        private String[] pool;

        public ConstantPool(String[] pool) {
            this();
            this.pool = pool;
        }

        public ConstantPool() {
            super(136, 5);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            ConstantPool action = new ConstantPool();
            action.pool = new String[swf.readUnsignedShort()];
            int i = 0;
            while (i < action.pool.length) {
                action.pool[i] = swf.readString();
                ++i;
            }
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeUnsignedShort(this.pool.length);
            int i = 0;
            while (i < this.pool.length) {
                swf.writeString(this.pool[i]);
                ++i;
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer(super.toString());
            s.append("[");
            int i = 0;
            while (i < this.pool.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(this.pool[i]);
                ++i;
            }
            s.append("]");
            return s.toString();
        }
    }

    public static class StoreRegister
    extends SWFAction {
        private byte number;

        public StoreRegister(byte number) {
            this();
            this.number = number;
        }

        public StoreRegister() {
            super(135, 5);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            StoreRegister action = new StoreRegister();
            action.number = swf.readByte();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeByte(this.number);
        }

        public String toString() {
            return super.toString() + ", " + this.number;
        }
    }

    public static class MBAsciiToChar
    extends SWFAction {
        public MBAsciiToChar() {
            super(55, 4);
        }
    }

    public static class MBCharToAscii
    extends SWFAction {
        public MBCharToAscii() {
            super(54, 4);
        }
    }

    public static class MBStringExtract
    extends SWFAction {
        public MBStringExtract() {
            super(53, 4);
        }
    }

    public static class GetTime
    extends SWFAction {
        public GetTime() {
            super(52, 4);
        }
    }

    public static class AsciiToChar
    extends SWFAction {
        public AsciiToChar() {
            super(51, 4);
        }
    }

    public static class CharToAscii
    extends SWFAction {
        public CharToAscii() {
            super(50, 4);
        }
    }

    public static class MBStringLength
    extends SWFAction {
        public MBStringLength() {
            super(49, 4);
        }
    }

    public static class RandomNumber
    extends SWFAction {
        public RandomNumber() {
            super(48, 4);
        }
    }

    public static class StringLess
    extends SWFAction {
        public StringLess() {
            super(41, 4);
        }
    }

    public static class EndDrag
    extends SWFAction {
        public EndDrag() {
            super(40, 4);
        }
    }

    public static class StartDrag
    extends SWFAction {
        public StartDrag() {
            super(39, 4);
        }
    }

    public static class Trace
    extends SWFAction {
        public Trace() {
            super(38, 4);
        }
    }

    public static class RemoveSprite
    extends SWFAction {
        public RemoveSprite() {
            super(37, 4);
        }
    }

    public static class CloneSprite
    extends SWFAction {
        public CloneSprite() {
            super(36, 4);
        }
    }

    public static class SetProperty
    extends SWFAction {
        public SetProperty() {
            super(35, 4);
        }
    }

    public static class GetProperty
    extends SWFAction {
        public GetProperty() {
            super(34, 4);
        }
    }

    public static class StringAdd
    extends SWFAction {
        public StringAdd() {
            super(33, 4);
        }
    }

    public static class SetTarget2
    extends SWFAction {
        public SetTarget2() {
            super(32, 4);
        }
    }

    public static class GotoFrame2
    extends SWFAction {
        private byte play;

        public GotoFrame2(byte play) {
            this();
            this.play = play;
        }

        public GotoFrame2() {
            super(159, 4);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            GotoFrame2 action = new GotoFrame2();
            action.play = swf.readByte();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeByte(this.play);
        }

        public String toString() {
            return super.toString() + ", " + this.play;
        }
    }

    public static class Call
    extends SWFAction {
        public Call() {
            super(158, 4);
        }
    }

    public static class If
    extends SWFAction {
        private short offset;

        public If(short offset) {
            this();
            this.offset = offset;
        }

        public If() {
            super(157, 4);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            If action = new If();
            action.offset = swf.readShort();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeShort(this.offset);
        }

        public String toString() {
            return super.toString() + ", " + this.offset;
        }
    }

    public static class SetVariable
    extends SWFAction {
        public SetVariable() {
            super(29, 4);
        }
    }

    public static class GetVariable
    extends SWFAction {
        public GetVariable() {
            super(28, 4);
        }
    }

    public static class GetURL2
    extends SWFAction {
        private byte method;
        public static final int NONE = 0;
        public static final int GET = 1;
        public static final int POST = 2;

        public GetURL2(byte method) {
            this();
            this.method = method;
        }

        public GetURL2() {
            super(154, 4);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            GetURL2 action = new GetURL2();
            action.method = swf.readByte();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeByte(this.method);
        }

        public String toString() {
            return super.toString() + ", " + this.method;
        }
    }

    public static class Jump
    extends SWFAction {
        private short offset;

        public Jump(short offset) {
            this();
            this.offset = offset;
        }

        public Jump() {
            super(153, 4);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            Jump action = new Jump();
            action.offset = swf.readShort();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeShort(this.offset);
        }

        public String toString() {
            return super.toString() + ", " + this.offset;
        }
    }

    public static class ToInteger
    extends SWFAction {
        public ToInteger() {
            super(24, 4);
        }
    }

    public static class Pop
    extends SWFAction {
        public Pop() {
            super(23, 4);
        }
    }

    public static class Push
    extends SWFAction {
        public static final int STRING = 0;
        public static final int FLOAT = 1;
        public static final int NULL = 2;
        public static final int UNDEFINED = 3;
        public static final int REGISTER = 4;
        public static final int BOOLEAN = 5;
        public static final int DOUBLE = 6;
        public static final int INTEGER = 7;
        public static final int LOOKUP = 8;
        public static final int LOOKUP2 = 9;
        private Vector values;

        public Push() {
            super(150, 4);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            Push action = new Push();
            action.values = new Vector();
            try {
                while (true) {
                    action.values.add(Value.read(swf));
                }
            }
            catch (EOFException e) {
                return action;
            }
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            int i = 0;
            while (i < this.values.size()) {
                ((Value)this.values.get(i)).write(swf);
                ++i;
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer(super.toString());
            s.append("\n");
            int i = 0;
            while (i < this.values.size()) {
                s.append("   ");
                s.append(this.values.get(i));
                s.append("\n");
                ++i;
            }
            return s.toString();
        }

        public static class Value {
            private byte type;
            private Object value;
            private byte[] data;

            public Value(String s) {
                this.type = 0;
                this.value = s;
            }

            public Value(float f) {
                this.type = 1;
                this.value = new Float(f);
            }

            public Value(Object x) {
                this.type = (byte)2;
                this.value = null;
            }

            public Value(byte r) {
                this.type = (byte)4;
                this.value = new Byte(r);
            }

            public Value(boolean b) {
                this.type = (byte)5;
                this.value = new Boolean(b);
            }

            public Value(double d) {
                this.type = (byte)6;
                this.value = new Double(d);
            }

            public Value(int i) {
                this.type = (byte)7;
                this.value = new Integer(i);
            }

            public Value(short index) {
                this.type = (byte)8;
                this.value = new Short(index);
            }

            public Value(byte type, byte[] data) {
                this.type = type;
                this.data = data;
            }

            public static Value read(SWFInputStream swf) throws IOException {
                byte type = swf.readByte();
                switch (type) {
                    case 0: {
                        return new Value(swf.readString());
                    }
                    case 1: {
                        return new Value(swf.readFloat());
                    }
                    case 2: {
                        return new Value(null);
                    }
                    case 4: {
                        return new Value((byte)swf.readUnsignedByte());
                    }
                    case 5: {
                        return new Value(swf.readByte() != 0);
                    }
                    case 6: {
                        return new Value(swf.readDouble());
                    }
                    case 7: {
                        return new Value(swf.readInt());
                    }
                    case 8: {
                        return new Value((short)swf.readUnsignedByte());
                    }
                    case 9: {
                        return new Value(9, swf.readByte(2));
                    }
                }
                return new Value(type, swf.readByte((int)swf.getLength()));
            }

            public void write(SWFOutputStream swf) throws IOException {
                swf.writeByte(this.type);
                switch (this.type) {
                    case 0: {
                        swf.writeString((String)this.value);
                        break;
                    }
                    case 1: {
                        swf.writeFloat(((Float)this.value).floatValue());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        swf.writeUnsignedByte(((Byte)this.value).byteValue());
                        break;
                    }
                    case 5: {
                        swf.writeBoolean((Boolean)this.value);
                        break;
                    }
                    case 6: {
                        swf.writeDouble((Double)this.value);
                        break;
                    }
                    case 7: {
                        swf.writeInt((Integer)this.value);
                        break;
                    }
                    case 8: {
                        swf.writeUnsignedByte(((Short)this.value).shortValue());
                        break;
                    }
                    case 9: {
                        swf.writeShort(((Short)this.value).shortValue());
                        break;
                    }
                    default: {
                        swf.writeByte(this.data);
                    }
                }
            }

            public String toString() {
                StringBuffer s = new StringBuffer("PushValue ");
                if (this.type < 0 || this.type > 9) {
                    s.append("Unknown Data Type " + this.type + " with length " + this.data.length);
                } else {
                    s.append(this.value);
                }
                return s.toString();
            }
        }
    }

    public static class StringExtract
    extends SWFAction {
        public StringExtract() {
            super(21, 4);
        }
    }

    public static class StringLength
    extends SWFAction {
        public StringLength() {
            super(20, 4);
        }
    }

    public static class StringEquals
    extends SWFAction {
        public StringEquals() {
            super(19, 4);
        }
    }

    public static class Not
    extends SWFAction {
        public Not() {
            super(18, 4);
        }
    }

    public static class Or
    extends SWFAction {
        public Or() {
            super(17, 4);
        }
    }

    public static class And
    extends SWFAction {
        public And() {
            super(16, 4);
        }
    }

    public static class Less
    extends SWFAction {
        public Less() {
            super(15, 4);
        }
    }

    public static class Equals
    extends SWFAction {
        public Equals() {
            super(14, 4);
        }
    }

    public static class WaitForFrame2
    extends SWFAction {
        private int skip;

        public WaitForFrame2(int skip) {
            this();
            this.skip = skip;
        }

        public WaitForFrame2() {
            super(141, 4);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            WaitForFrame2 action = new WaitForFrame2();
            action.skip = swf.readUnsignedByte();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeUnsignedByte(this.skip);
        }

        public String toString() {
            return super.toString() + ", skipCount:" + this.skip;
        }
    }

    public static class Divide
    extends SWFAction {
        public Divide() {
            super(13, 4);
        }
    }

    public static class Multiply
    extends SWFAction {
        public Multiply() {
            super(12, 4);
        }
    }

    public static class Subtract
    extends SWFAction {
        public Subtract() {
            super(11, 4);
        }
    }

    public static class Add
    extends SWFAction {
        public Add() {
            super(10, 4);
        }
    }

    public static class GotoLabel
    extends SWFAction {
        private String label;

        public GotoLabel(String label) {
            this();
            this.label = label;
        }

        public GotoLabel() {
            super(140, 3);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            GotoLabel action = new GotoLabel();
            action.label = swf.readString();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeString(this.label);
        }

        public String toString() {
            return super.toString() + ", label " + this.label;
        }
    }

    public static class SetTarget
    extends SWFAction {
        private String target;

        public SetTarget(String target) {
            this();
            this.target = target;
        }

        public SetTarget() {
            super(139, 3);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            SetTarget action = new SetTarget();
            action.target = swf.readString();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeString(this.target);
        }

        public String toString() {
            return super.toString() + ", target " + this.target;
        }
    }

    public static class WaitForFrame
    extends SWFAction {
        private int frame;
        private int skip;

        public WaitForFrame(int frame, int skip) {
            this();
            this.frame = frame;
            this.skip = skip;
        }

        public WaitForFrame() {
            super(138, 3);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            WaitForFrame action = new WaitForFrame();
            action.frame = swf.readUnsignedShort();
            action.skip = swf.readUnsignedByte();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeUnsignedShort(this.frame);
            swf.writeUnsignedByte(this.skip);
        }

        public String toString() {
            return super.toString() + ", frame " + this.frame + ", skip " + this.skip;
        }
    }

    public static class StopSounds
    extends SWFAction {
        public StopSounds() {
            super(9, 3);
        }
    }

    public static class ToggleQuality
    extends SWFAction {
        public ToggleQuality() {
            super(8, 3);
        }
    }

    public static class Stop
    extends SWFAction {
        public Stop() {
            super(7, 3);
        }
    }

    public static class Play
    extends SWFAction {
        public Play() {
            super(6, 3);
        }
    }

    public static class PreviousFrame
    extends SWFAction {
        public PreviousFrame() {
            super(5, 3);
        }
    }

    public static class NextFrame
    extends SWFAction {
        public NextFrame() {
            super(4, 3);
        }
    }

    public static class GetURL
    extends SWFAction {
        private String url;
        private String window;

        public GetURL(String url, String window) {
            this();
            this.url = url;
            this.window = window;
        }

        public GetURL() {
            super(131, 3);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            GetURL action = new GetURL();
            action.url = swf.readString();
            action.window = swf.readString();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeString(this.url);
            swf.writeString(this.window);
        }

        public String toString() {
            return super.toString() + ", URL " + this.url + ", window " + this.window;
        }
    }

    public static class GotoFrame
    extends SWFAction {
        private int frame;

        public GotoFrame(int frame) {
            this();
            this.frame = frame;
        }

        public GotoFrame() {
            super(129, 3);
        }

        public SWFAction read(int actionCode, SWFInputStream swf, int length) throws IOException {
            GotoFrame action = new GotoFrame();
            action.frame = swf.readUnsignedShort();
            return action;
        }

        public void write(int actionCode, SWFOutputStream swf) throws IOException {
            swf.writeUnsignedShort(this.frame);
        }

        public String toString() {
            return super.toString() + ", frame " + this.frame;
        }
    }
}

