/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SoundEnvelope;

public class SoundInfo {
    private boolean syncStop;
    private boolean syncNoMultiple;
    private long inPoint = -1L;
    private long outPoint = -1L;
    private int loop = -1;
    private SoundEnvelope[] envelope;

    public SoundInfo(boolean syncStop, boolean syncNoMultiple, long inPoint, long outPoint, int loop, SoundEnvelope[] envelope) {
        this.syncStop = syncStop;
        this.syncNoMultiple = syncNoMultiple;
        this.inPoint = inPoint;
        this.outPoint = outPoint;
        this.loop = loop;
        this.envelope = envelope;
    }

    public SoundInfo(SWFInputStream input) throws IOException {
        input.readUBits(2);
        this.syncStop = input.readBitFlag();
        this.syncNoMultiple = input.readBitFlag();
        boolean hasEnvelope = input.readBitFlag();
        boolean hasLoops = input.readBitFlag();
        boolean hasOutPoint = input.readBitFlag();
        boolean hasInPoint = input.readBitFlag();
        if (hasInPoint) {
            this.inPoint = input.readUnsignedInt();
        }
        if (hasOutPoint) {
            this.outPoint = input.readUnsignedInt();
        }
        if (hasLoops) {
            this.loop = input.readUnsignedShort();
        }
        if (hasEnvelope) {
            int numPoints = input.readUnsignedByte();
            this.envelope = new SoundEnvelope[numPoints];
            int i = 0;
            while (i < numPoints) {
                this.envelope[i] = new SoundEnvelope(input);
                ++i;
            }
        }
    }

    public void write(SWFOutputStream swf) throws IOException {
        swf.writeUBits(0L, 2);
        swf.writeBitFlag(this.syncStop);
        swf.writeBitFlag(this.syncNoMultiple);
        swf.writeBitFlag(this.envelope != null);
        swf.writeBitFlag(this.loop >= 0);
        swf.writeBitFlag(this.outPoint >= 0L);
        swf.writeBitFlag(this.inPoint >= 0L);
        if (this.inPoint >= 0L) {
            swf.writeUnsignedInt(this.inPoint);
        }
        if (this.outPoint >= 0L) {
            swf.writeUnsignedInt(this.outPoint);
        }
        if (this.loop >= 0) {
            swf.writeUnsignedShort(this.loop);
        }
        if (this.envelope != null) {
            swf.writeUnsignedByte(this.envelope.length);
            int i = 0;
            while (i < this.envelope.length) {
                this.envelope[i].write(swf);
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("SoundInfo ");
        s.append("syncStop: " + this.syncStop);
        s.append(", syncNoMultiple: " + this.syncNoMultiple);
        s.append(", in: " + this.inPoint);
        s.append(", out: " + this.outPoint);
        s.append(", loop: " + this.loop);
        if (this.envelope != null) {
            s.append(" [");
            int i = 0;
            while (i < this.envelope.length) {
                s.append(this.envelope[i]);
                s.append(" ");
                ++i;
            }
            s.append("]");
        }
        return s.toString();
    }
}

