/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.print.table;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.table.TableModel;
import org.freehep.swing.print.table.CellPrinter;
import org.freehep.swing.print.table.PrintModelAdapter;
import org.freehep.swing.print.table.PrintableTableModel;

public class TablePrinter
implements Pageable,
Printable {
    private Font cellFont;
    private Font headerFont;
    private FontRenderContext lastFontRenderContext;
    private PageFormat pf;
    private PrintableTableModel model;
    private float[] widths;
    private float headerHeight;
    private float rowHeight;
    private int nPages = -1;
    private int rowsPerPage;

    public TablePrinter(PrintableTableModel model, PageFormat pf, Font headerFont, Font cellFont, FontRenderContext frc) {
        this.pf = pf;
        this.model = model;
        this.headerFont = headerFont;
        this.cellFont = cellFont;
        this.calculateTableSize(pf, frc);
    }

    public TablePrinter(TableModel model, String title, PageFormat pf, Font headerFont, Font cellFont, FontRenderContext frc) {
        this(new PrintModelAdapter(model, title), pf, headerFont, cellFont, frc);
    }

    public int getNumberOfPages() {
        return this.nPages;
    }

    public PageFormat getPageFormat(int p1) {
        return this.pf;
    }

    public Printable getPrintable(int p1) {
        return this;
    }

    public int print(Graphics g, PageFormat pf, int page) {
        int c;
        Graphics2D g2 = (Graphics2D)g;
        FontRenderContext frc = g2.getFontRenderContext();
        if (!frc.equals(this.lastFontRenderContext)) {
            this.calculateTableSize(pf, frc);
        }
        if (page >= this.nPages) {
            return 1;
        }
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(0.0f));
        float xx = (float)pf.getImageableX();
        float yy = (float)pf.getImageableY();
        float totalWidth = 4.0f;
        int i = 0;
        while (i < this.widths.length) {
            if (this.widths[i] > 0.0f) {
                totalWidth += this.widths[i] + 3.0f;
            }
            ++i;
        }
        float y = 4.0f + xx;
        float x = 4.0f + yy;
        Rectangle2D.Float rect = new Rectangle2D.Float();
        int c2 = 0;
        while (c2 < this.model.numberOfColumns()) {
            if (this.widths[c2] != 0.0f) {
                rect.setRect(x, y, this.widths[c2], this.headerHeight);
                CellPrinter cp = this.model.getHeaderPrinter(c2);
                cp.setFont(this.headerFont);
                cp.setValue(this.model.headerForColumn(c2));
                cp.print(g, rect);
                x += this.widths[c2] + 3.0f;
            }
            ++c2;
        }
        y += this.headerHeight + 1.0f;
        Line2D.Float line = new Line2D.Float();
        int r = page * this.rowsPerPage;
        while (r < (page + 1) * this.rowsPerPage) {
            if (r >= this.model.numberOfRows()) break;
            x = 4.0f + xx;
            c = 0;
            while (c < this.model.numberOfColumns()) {
                if (this.widths[c] != 0.0f) {
                    rect.setRect(x, y, this.widths[c], this.rowHeight);
                    CellPrinter cp = this.model.getCellPrinter(c);
                    cp.setFont(this.cellFont);
                    cp.setValue(this.model.valueAt(r, c));
                    cp.print(g, rect);
                    x += this.widths[c] + 3.0f;
                }
                ++c;
            }
            ((Line2D)line).setLine(xx, y - 1.0f, xx + totalWidth, y - 1.0f);
            g2.draw(line);
            y += this.rowHeight + 1.0f;
            ++r;
        }
        x = xx + 2.0f;
        c = 0;
        while (c < this.model.numberOfColumns() - 1) {
            if (this.widths[c] != 0.0f) {
                ((Line2D)line).setLine(x += this.widths[c] + 3.0f, yy + 1.0f, x, y);
                g2.draw(line);
            }
            ++c;
        }
        g2.setStroke(new BasicStroke(2.0f));
        rect.setRect(xx + 1.0f, yy + 2.0f, totalWidth, y - yy);
        g2.draw(rect);
        String footer = "Page " + (page + 1) + " of " + this.nPages;
        g2.drawString(footer, xx, yy + (float)pf.getImageableHeight() - (float)g.getFontMetrics().getDescent());
        return 0;
    }

    private void calculateTableSize(PageFormat pf, FontRenderContext frc) {
        this.lastFontRenderContext = frc;
        double height = pf.getImageableHeight();
        double width = pf.getImageableWidth();
        this.widths = new float[this.model.numberOfColumns()];
        this.headerHeight = 0.0f;
        this.rowHeight = 0.0f;
        int c = 0;
        while (c < this.model.numberOfColumns()) {
            if (!this.model.hideColumn(c)) {
                CellPrinter hp = this.model.getHeaderPrinter(c);
                hp.setFont(this.headerFont);
                hp.setValue(this.model.headerForColumn(c));
                this.widths[c] = hp.getWidth(frc);
                float h = hp.getHeight(frc);
                if (h > this.headerHeight) {
                    this.headerHeight = h;
                }
                CellPrinter cp = this.model.getCellPrinter(c);
                cp.setFont(this.cellFont);
                int r = 0;
                while (r < this.model.numberOfRows()) {
                    cp.setValue(this.model.valueAt(r, c));
                    float w = cp.getWidth(frc);
                    if (w > this.widths[c]) {
                        this.widths[c] = w;
                    }
                    if ((h = cp.getHeight(frc)) > this.rowHeight) {
                        this.rowHeight = h;
                    }
                    ++r;
                }
            }
            ++c;
        }
        int nRows = this.model.numberOfRows();
        double effectiveHeight = height - (double)this.headerHeight - 6.0 - (double)this.rowHeight;
        this.rowsPerPage = (int)Math.floor(effectiveHeight / (double)(this.rowHeight + 1.0f));
        this.nPages = 1 + (nRows - 1) / this.rowsPerPage;
    }
}

