/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.wizard;

import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import org.freehep.swing.wizard.Finishable;
import org.freehep.swing.wizard.HasNextPages;
import org.freehep.swing.wizard.WizardDialog;

public abstract class WizardPage
extends JPanel
implements KeyListener {
    static int pageNumber = 0;
    private WizardDialog m_wizard;
    private WizardPage m_prev = null;
    private WizardPage[] m_nextWizardPages = null;
    private boolean m_hasNextPages;
    private boolean m_isFinishable = this instanceof Finishable;
    private String m_number;
    private boolean m_nextEnabled = true;

    public WizardPage(LayoutManager lm) {
        super(lm);
        this.m_hasNextPages = this instanceof HasNextPages;
    }

    public WizardPage() {
        this.m_hasNextPages = this instanceof HasNextPages;
    }

    public void beforeShowing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBusy(Runnable run) {
        this.m_wizard.setToWaitCursor();
        try {
            run.run();
            Object var3_2 = null;
            this.m_wizard.setToDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_wizard.setToDefaultCursor();
            throw throwable;
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 10) {
            this.doEnable();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void onCancel() {
    }

    public String toString() {
        return this.m_number;
    }

    protected boolean getFinishEnabled() {
        return this.m_isFinishable;
    }

    protected boolean getNextEnabled() {
        return this.m_hasNextPages && this.m_nextEnabled;
    }

    protected void setNextEnabled(boolean enabled) {
        if (enabled != this.m_nextEnabled) {
            this.m_nextEnabled = enabled;
            this.doEnable();
        }
    }

    protected void dispose() {
        this.m_wizard.dispose();
    }

    protected void doEnable() {
        if (this.m_wizard == null) {
            return;
        }
        this.m_wizard.setNextEnabled(this.getNextEnabled());
        this.m_wizard.setFinishEnabled(this.getFinishEnabled());
        this.m_wizard.doPrevEnabled();
        if (this.m_isFinishable && this.m_hasNextPages) {
            this.m_wizard.setDefaultButton();
        }
    }

    protected void handleError(String message, Throwable t) {
        this.m_wizard.handleError(message, t);
    }

    boolean isFinishable() {
        return this.m_isFinishable;
    }

    WizardPage getPrev() {
        return this.m_prev;
    }

    void addTo(Container c, WizardDialog wizard, WizardPage prev) {
        this.m_number = String.valueOf(pageNumber++);
        c.add(this.m_number, this);
        if (this.m_hasNextPages) {
            this.m_nextWizardPages = ((HasNextPages)((Object)this)).getNextWizardPages();
            if (this.m_nextWizardPages != null) {
                int i = 0;
                while (i < this.m_nextWizardPages.length) {
                    if (this.m_nextWizardPages[i] != null) {
                        this.m_nextWizardPages[i].addTo(c, wizard, this);
                    }
                    ++i;
                }
            }
        }
        this.m_wizard = wizard;
        this.m_prev = prev;
    }

    void clear() {
        if (this.m_hasNextPages) {
            int i = 0;
            while (i < this.m_nextWizardPages.length) {
                if (this.m_nextWizardPages[i] != null) {
                    this.m_nextWizardPages[i].clear();
                }
                ++i;
            }
            this.m_nextWizardPages = null;
        }
        this.m_prev = null;
        this.m_wizard = null;
    }

    void doCancel() {
        if (this.m_nextWizardPages != null) {
            int i = 0;
            while (i < this.m_nextWizardPages.length) {
                if (this.m_nextWizardPages[i] != null) {
                    this.m_nextWizardPages[i].doCancel();
                }
                ++i;
            }
        }
        this.onCancel();
    }

    boolean hasNextPages() {
        return this.m_hasNextPages;
    }
}

