/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.images;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageHandler {
    public static final Image brokenImage;
    public static final Cursor brokenCursor;
    public static final Icon brokenIcon;
    private static String[] imageExtensions;
    private static Hashtable imageCache;
    private static Hashtable cursorCache;
    private static Hashtable iconCache;
    static /* synthetic */ Class class$org$freehep$util$images$ImageHandler;

    protected ImageHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URL url) {
        Image image = null;
        image = url != null ? (Image)imageCache.get(url) : brokenImage;
        if (image == null && url != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            try {
                InputStream in = url.openStream();
                try {
                    int rc;
                    int length = in.available();
                    if (length == 0) {
                        length = 1000;
                    }
                    byte[] bytes = new byte[length];
                    int offset = 0;
                    while ((rc = in.read(bytes, offset, length - offset)) >= 0) {
                        if (rc > 0) {
                            offset += rc;
                            continue;
                        }
                        byte[] newBytes = new byte[length += 1000];
                        System.arraycopy(bytes, 0, newBytes, 0, offset);
                        bytes = newBytes;
                    }
                    image = toolkit.createImage(bytes);
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                {
                }
            }
            catch (IOException x) {
                image = brokenImage;
            }
            if (url != null) {
                imageCache.put(url, image);
            }
        }
        return image;
    }

    public static Cursor getBestCursor(String name, Class clazz, int width, int height) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(width, height);
        if (dimension.width == 0 && dimension.height == 0) {
            return Cursor.getDefaultCursor();
        }
        name = name.replaceAll("%w", Integer.toString(dimension.width));
        name = name.replaceAll("%h", Integer.toString(dimension.height));
        return ImageHandler.getCursor(name, clazz);
    }

    public static Cursor getCursor(URL url) {
        return ImageHandler.getCursor(url, 0, 0);
    }

    public static Cursor getCursor(URL url, int x, int y) {
        Cursor cursor;
        Cursor cursor2 = cursor = url != null ? (Cursor)cursorCache.get(url) : null;
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = ImageHandler.getImage(url);
            cursor = image == brokenImage ? brokenCursor : toolkit.createCustomCursor(image, new Point(x, y), url.getFile());
            if (url != null) {
                cursorCache.put(url, cursor);
            }
        }
        return cursor;
    }

    public static Icon getIcon(URL url) {
        Icon icon;
        Icon icon2 = icon = url != null ? (Icon)iconCache.get(url) : null;
        if (icon == null) {
            Image image = ImageHandler.getImage(url);
            icon = image == brokenImage ? brokenIcon : new ImageIcon(image, url.getFile());
            if (url != null) {
                iconCache.put(url, icon);
            }
        }
        return icon;
    }

    public static Image getImage(String name, Class clazz) {
        if (name.indexOf(46) >= 0) {
            return ImageHandler.getImage(clazz.getResource(name));
        }
        int i = 0;
        while (i < imageExtensions.length) {
            URL url = clazz.getResource(name + imageExtensions[i]);
            if (url != null) {
                return ImageHandler.getImage(url);
            }
            ++i;
        }
        return brokenImage;
    }

    public static Cursor getCursor(String name, Class clazz) {
        if (name.indexOf(46) >= 0) {
            return ImageHandler.getCursor(clazz.getResource(name));
        }
        int i = 0;
        while (i < imageExtensions.length) {
            URL url = clazz.getResource(name + imageExtensions[i]);
            if (url != null) {
                return ImageHandler.getCursor(url);
            }
            ++i;
        }
        return brokenCursor;
    }

    public static Icon getIcon(String name, Class clazz) {
        if (name.indexOf(46) >= 0) {
            return ImageHandler.getIcon(clazz.getResource(name));
        }
        int i = 0;
        while (i < imageExtensions.length) {
            URL url = clazz.getResource(name + imageExtensions[i]);
            if (url != null) {
                return ImageHandler.getIcon(url);
            }
            ++i;
        }
        return brokenIcon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        imageExtensions = new String[]{".png", ".gif", ".jpeg", ".jpg"};
        imageCache = new Hashtable();
        cursorCache = new Hashtable();
        iconCache = new Hashtable();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        brokenImage = toolkit.getImage((class$org$freehep$util$images$ImageHandler == null ? (class$org$freehep$util$images$ImageHandler = ImageHandler.class$("org.freehep.util.images.ImageHandler")) : class$org$freehep$util$images$ImageHandler).getResource("BrokenImage.gif"));
        if (brokenImage == null) {
            throw new RuntimeException("Could not load BrokenIcon .. this looks bad!");
        }
        brokenIcon = new ImageIcon(brokenImage, "BrokenIcon");
        Image brokenCursorImage = toolkit.getImage((class$org$freehep$util$images$ImageHandler == null ? (class$org$freehep$util$images$ImageHandler = ImageHandler.class$("org.freehep.util.images.ImageHandler")) : class$org$freehep$util$images$ImageHandler).getResource("BrokenCursor.gif"));
        brokenCursor = GraphicsEnvironment.isHeadless() ? Cursor.getPredefinedCursor(3) : (brokenCursorImage != null ? toolkit.createCustomCursor(brokenCursorImage, new Point(0, 0), "BrokenCursor") : null);
        if (brokenCursor == null) {
            throw new RuntimeException("Could not load BrokenCursor .. this looks bad!");
        }
    }
}

