/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.images;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TempImageHandler {
    private static Image brokenImage;
    private static Cursor brokenCursor;
    private static String[] imageExtensions;
    private static Hashtable imageCache;
    private static Hashtable cursorCache;
    private static Hashtable iconCache;
    static /* synthetic */ Class class$org$freehep$util$images$TempImageHandler;

    protected TempImageHandler() {
    }

    public static Image getImage(String name, Class clazz) {
        Image image = (Image)imageCache.get(name);
        if (image == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int i = 0;
            while (image == null && i < imageExtensions.length) {
                byte[] imageBytes = TempImageHandler.getImageBytes(name + imageExtensions[i], clazz);
                if (imageBytes != null) {
                    image = toolkit.createImage(imageBytes);
                }
                ++i;
            }
            if (image != null) {
                imageCache.put(name, image);
            } else {
                image = brokenImage;
            }
        }
        return image;
    }

    public static Cursor getCursor(String name, Class clazz) {
        return TempImageHandler.getCursor(name, clazz, 0, 0);
    }

    public static Cursor getCursor(String name, Class clazz, int x, int y) {
        Cursor cursor = (Cursor)cursorCache.get(name);
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = TempImageHandler.getImage(name, clazz);
            ImageIcon icon = new ImageIcon(image);
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            Dimension bestSize = toolkit.getBestCursorSize(icon.getIconWidth(), icon.getIconHeight());
            int cursorWidth = bestSize.width;
            int cursorHeight = bestSize.height;
            if (cursorWidth < iconWidth || cursorHeight < iconHeight) {
                image = image.getScaledInstance(cursorWidth, cursorHeight, 1);
            } else if (iconWidth != cursorWidth || iconHeight != cursorHeight) {
                BufferedImage bimage = new BufferedImage(cursorWidth, cursorHeight, 2);
                Graphics2D g2d = (Graphics2D)bimage.getGraphics();
                Color trans = new Color(0, 0, 0, 0);
                g2d.setColor(trans);
                g2d.fillRect(0, 0, cursorWidth, cursorHeight);
                g2d.drawImage(icon.getImage(), 0, 0, null);
                image = bimage;
            }
            if (image == brokenImage) {
                cursor = brokenCursor;
            } else if (image != null && (cursor = toolkit.createCustomCursor(image, new Point(x, y), "" + name)) != null) {
                cursorCache.put(name, cursor);
            }
        }
        return cursor;
    }

    public static Icon getIcon(String name, Class clazz) {
        Icon icon = (Icon)iconCache.get(name);
        if (icon == null) {
            Image image = TempImageHandler.getImage(name, clazz);
            if (image != null) {
                icon = new ImageIcon(image, name);
            }
            if (icon != null && image != brokenImage) {
                iconCache.put(name, icon);
            }
        }
        return icon;
    }

    private static byte[] getImageBytes(String name, Class clazz) {
        try {
            InputStream stream = clazz.getResourceAsStream(name);
            if (stream == null) {
                return null;
            }
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            int maxBytes = 10000;
            byte[] buffer = new byte[maxBytes];
            int bytesRead = stream.read(buffer);
            while (bytesRead > 0) {
                ostream.write(buffer, 0, bytesRead);
                bytesRead = stream.read(buffer);
            }
            stream.close();
            return ostream.toByteArray();
        }
        catch (IOException x) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Image brokenCursorImage;
        imageExtensions = new String[]{".gif", ".png"};
        imageCache = new Hashtable();
        cursorCache = new Hashtable();
        iconCache = new Hashtable();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] brokenImageBytes = TempImageHandler.getImageBytes("BrokenImage.gif", class$org$freehep$util$images$TempImageHandler == null ? (class$org$freehep$util$images$TempImageHandler = TempImageHandler.class$("org.freehep.util.images.TempImageHandler")) : class$org$freehep$util$images$TempImageHandler);
        if (brokenImageBytes != null) {
            brokenImage = toolkit.createImage(brokenImageBytes);
        }
        if (brokenImage == null) {
            throw new RuntimeException("Could not load BrokenIcon");
        }
        byte[] brokenCursorBytes = TempImageHandler.getImageBytes("BrokenCursor.gif", class$org$freehep$util$images$TempImageHandler == null ? (class$org$freehep$util$images$TempImageHandler = TempImageHandler.class$("org.freehep.util.images.TempImageHandler")) : class$org$freehep$util$images$TempImageHandler);
        if (brokenCursorBytes != null && (brokenCursorImage = toolkit.createImage(brokenCursorBytes)) != null) {
            brokenCursor = toolkit.createCustomCursor(brokenCursorImage, new Point(0, 0), "BrokenCursor");
        }
        if (brokenCursor == null) {
            throw new RuntimeException("Could not load BrokenCursor");
        }
    }
}

