/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import java.util.logging.Logger;
import prefuse.action.ItemAction;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public class ArrayAnimator
extends ItemAction {
    private static final Logger s_logger = Logger.getLogger(ArrayAnimator.class.getName());
    private String m_field;
    private String m_start;
    private String m_end;

    public ArrayAnimator(String string, String string2) {
        super(string);
        this.m_field = string2;
        this.m_start = PrefuseLib.getStartField(string2);
        this.m_end = PrefuseLib.getEndField(string2);
    }

    public void process(VisualItem visualItem, double d) {
        Object object = visualItem.get(this.m_field);
        if (object instanceof float[]) {
            float[] fArray = (float[])object;
            float[] fArray2 = (float[])visualItem.get(this.m_start);
            float[] fArray3 = (float[])visualItem.get(this.m_end);
            float f = (float)d;
            for (int i = 0; i < fArray.length && !Float.isNaN(fArray[i]); ++i) {
                fArray[i] = fArray2[i] + f * (fArray3[i] - fArray2[i]);
            }
            visualItem.setValidated(false);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])visualItem.get(this.m_start);
            double[] dArray3 = (double[])visualItem.get(this.m_end);
            for (int i = 0; i < dArray.length && !Double.isNaN(dArray[i]); ++i) {
                dArray[i] = dArray2[i] + d * (dArray3[i] - dArray2[i]);
            }
            visualItem.setValidated(false);
        } else {
            s_logger.warning("Encountered non-double/non-float array type: " + (object == null ? "null" : object.getClass().getName()));
        }
    }
}

