/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.util.StringLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class FocusControl
extends ControlAdapter {
    private String group = Visualization.FOCUS_ITEMS;
    protected String activity;
    protected VisualItem curFocus;
    protected int ccount;
    protected int button = 16;
    protected Predicate filter = null;

    public FocusControl() {
        this(1);
    }

    public FocusControl(String string) {
        this(1);
        this.group = string;
    }

    public FocusControl(int n) {
        this.ccount = n;
    }

    public FocusControl(String string, int n) {
        this.ccount = n;
        this.group = string;
    }

    public FocusControl(int n, String string) {
        this.ccount = n;
        this.activity = string;
    }

    public FocusControl(String string, int n, String string2) {
        this.ccount = n;
        this.activity = string2;
        this.group = string;
    }

    public void setFilter(Predicate predicate) {
        this.filter = predicate;
    }

    public Predicate getFilter() {
        return this.filter;
    }

    protected boolean filterCheck(VisualItem visualItem) {
        if (this.filter == null) {
            return true;
        }
        try {
            return this.filter.getBoolean(visualItem);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return false;
        }
    }

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!this.filterCheck(visualItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
        if (this.ccount == 0) {
            Visualization visualization = visualItem.getVisualization();
            TupleSet tupleSet = visualization.getFocusGroup(this.group);
            tupleSet.setTuple(visualItem);
            this.curFocus = visualItem;
            this.runActivity(visualization);
        }
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!this.filterCheck(visualItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
        if (this.ccount == 0) {
            this.curFocus = null;
            Visualization visualization = visualItem.getVisualization();
            TupleSet tupleSet = visualization.getFocusGroup(this.group);
            tupleSet.removeTuple(visualItem);
            this.runActivity(visualization);
        }
    }

    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!this.filterCheck(visualItem)) {
            return;
        }
        if (UILib.isButtonPressed(mouseEvent, this.button) && mouseEvent.getClickCount() == this.ccount) {
            if (visualItem != this.curFocus) {
                Visualization visualization = visualItem.getVisualization();
                TupleSet tupleSet = visualization.getFocusGroup(this.group);
                boolean bl = mouseEvent.isControlDown();
                if (!bl) {
                    this.curFocus = visualItem;
                    tupleSet.setTuple(visualItem);
                } else if (tupleSet.containsTuple(visualItem)) {
                    tupleSet.removeTuple(visualItem);
                } else {
                    tupleSet.addTuple(visualItem);
                }
                this.runActivity(visualization);
            } else if (mouseEvent.isControlDown()) {
                Visualization visualization = visualItem.getVisualization();
                TupleSet tupleSet = visualization.getFocusGroup(this.group);
                tupleSet.removeTuple(visualItem);
                this.curFocus = null;
                this.runActivity(visualization);
            }
        }
    }

    private void runActivity(Visualization visualization) {
        if (this.activity != null) {
            visualization.run(this.activity);
        }
    }
}

