/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class LongParser
implements DataParser {
    public Class getType() {
        return Long.TYPE;
    }

    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)object).longValue()) + "L";
    }

    public boolean canParse(String string) {
        try {
            LongParser.parseLong(string);
            return true;
        }
        catch (DataParseException dataParseException) {
            return false;
        }
    }

    public Object parse(String string) throws DataParseException {
        return new Long(LongParser.parseLong(string));
    }

    public static long parseLong(String string) throws DataParseException {
        try {
            char c;
            if (string.length() > 0 && ((c = string.charAt(string.length() - 1)) == 'l' || c == 'L')) {
                string = string.substring(0, string.length() - 1);
            }
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

