/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.util.Arrays;
import prefuse.util.ArrayLib;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;

public class RenderingQueue {
    private static final int DEFAULT_SIZE = 256;
    public ItemSorter sort = new ItemSorter();
    public VisualItem[] ritems = new VisualItem[256];
    public int[] rscores = new int[256];
    public int rsize = 0;
    public VisualItem[] pitems = new VisualItem[256];
    public int[] pscores = new int[256];
    public int psize = 0;
    public boolean psorted = false;
    static transient VisualItem[] items_buf;
    static transient int[] scores_buf;

    public void clear() {
        Arrays.fill(this.ritems, 0, this.rsize, null);
        Arrays.fill(this.pitems, 0, this.psize, null);
        this.rsize = 0;
        this.psize = 0;
    }

    public void addToRenderQueue(VisualItem visualItem) {
        if (this.ritems.length == this.rsize) {
            int n = 3 * this.ritems.length / 2 + 1;
            VisualItem[] visualItemArray = new VisualItem[n];
            int[] nArray = new int[n];
            System.arraycopy(this.ritems, 0, visualItemArray, 0, this.rsize);
            System.arraycopy(this.rscores, 0, nArray, 0, this.rsize);
            this.ritems = visualItemArray;
            this.rscores = nArray;
        }
        this.ritems[this.rsize] = visualItem;
        this.rscores[this.rsize++] = this.sort != null ? this.sort.score(visualItem) : 0;
    }

    public void addToPickingQueue(VisualItem visualItem) {
        if (this.pitems.length == this.psize) {
            int n = 3 * this.pitems.length / 2 + 1;
            VisualItem[] visualItemArray = new VisualItem[n];
            int[] nArray = new int[n];
            System.arraycopy(this.pitems, 0, visualItemArray, 0, this.psize);
            System.arraycopy(this.pscores, 0, nArray, 0, this.psize);
            this.pitems = visualItemArray;
            this.pscores = nArray;
        }
        this.pitems[this.psize] = visualItem;
        this.pscores[this.psize++] = this.sort != null ? this.sort.score(visualItem) : 0;
        this.psorted = false;
    }

    public void sortRenderQueue() {
        this.sort(this.ritems, this.rscores, this.rsize);
    }

    public void sortPickingQueue() {
        this.sort(this.pitems, this.pscores, this.psize);
        this.psorted = true;
    }

    private void sort(VisualItem[] visualItemArray, int[] nArray, int n) {
        if (this.sort == null) {
            return;
        }
        if (items_buf == null || items_buf.length < n) {
            items_buf = new VisualItem[visualItemArray.length];
            scores_buf = new int[nArray.length];
        }
        ArrayLib.sort(nArray, visualItemArray, scores_buf, items_buf, 0, n);
    }
}

